/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.BulkDataReference;
import com.archimed.dicom.ByteArray;
import com.archimed.dicom.ConvertUtils;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElementValue;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.validate.DicomDataValidator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DataElement
extends TagValue {
    public static final int ITEM_TAG_GROUP = 65534;
    public static final int ITEM_TAG_ELEMENT = 57344;
    public static final int SEQDELIM_TAG_GROUP = 65534;
    public static final int SEQDELIM_TAG_ELEMENT = 57565;
    public static final int ITEMDELIM_TAG_GROUP = 65534;
    public static final int ITEMDELIM_TAG_ELEMENT = 57357;
    public static final int UNDEFINED_LENGTH_INT = -1;
    public static final long UNDEFINED_LENGTH_LONG = 0xFFFFFFFFL;
    private static final long serialVersionUID = 1L;
    private static final long MAX_UL = 0xFFFFFFFFL;
    private static final long MIN_UL = 0L;
    private static final int MAX_SL = Integer.MAX_VALUE;
    private static final int MIN_SL = Integer.MIN_VALUE;
    private static final int MAX_IS = Integer.MAX_VALUE;
    private static final int MIN_IS = Integer.MIN_VALUE;
    private static final int MAX_SS = Short.MAX_VALUE;
    private static final int MIN_SS = Short.MIN_VALUE;
    private static final int MAX_US = 65535;
    private static final int MIN_US = 0;
    private static final BigInteger MAX_SV = BigInteger.ONE.shiftLeft(63).subtract(BigInteger.ONE);
    private static final BigInteger MIN_SV = BigInteger.ONE.shiftLeft(63).multiply(new BigInteger("-1"));
    private static final BigInteger MAX_UV = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private static final BigInteger MIN_UV = BigInteger.ZERO;
    private static final DicomCharset[] defaultCharsets = new DicomCharset[]{DicomCharset.DEFAULT};

    @Override
    public int getGroup() {
        return super.getGroup();
    }

    @Override
    public int getElement() {
        return super.getElement();
    }

    public int getTag() {
        return DDict.lookupDDict(this.getGroup(), this.getElement());
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public Object getValue(int index) {
        return this.val.get(index);
    }

    @Override
    public Object getValue() {
        return this.getValue(0);
    }

    public void setValue(Object object, int index) {
        if (index == this.val.size()) {
            this.addValue(object);
        } else {
            this.val.set(index, object);
        }
    }

    public void addValue(Object object) {
        this.val.add(object);
    }

    public int getVR() {
        return this.dcm_type;
    }

    public int getValueLength() {
        return (int)this.dataLen;
    }

    public long getValueLengthAsLong() {
        return this.dataLen;
    }

    public void clear() {
        this.val.clear();
    }

    public Object removeValue(int index) {
        return this.val.remove(index);
    }

    public String getString(int index) throws DicomException {
        return this.getString(index, true);
    }

    public String getString(int index, boolean trim) {
        if (this.getValue(index) instanceof BulkDataReference) {
            return ((BulkDataReference)this.getValue(index)).getDescription();
        }
        switch (this.dcm_type) {
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 27: 
            case 32: {
                byte[] ar = (byte[])this.getValue(index);
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, this.dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], this.dcm.dicomCharsets());
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length, this.dcm.dicomCharsets());
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 33: {
                byte[] ar = (byte[])this.getValue(index);
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, this.dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], defaultCharsets);
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length, defaultCharsets);
            }
            case 2: {
                byte[] ar = (byte[])this.getValue(index);
                int[] pos = ConvertUtils.trim(ar, this.dcm_type);
                return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], defaultCharsets);
            }
            case 1: 
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 35: 
            case 36: {
                Object val = this.getValue(index);
                return val == null ? null : val.toString();
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                return ((DataElementValue)this.getValue(index)).getDescription();
            }
            case 5: {
                ATValue at = (ATValue)this.getValue(index);
                int g = at.getGroup();
                int e = at.getElement();
                String s = "(" + DumpUtils.toShortHexString(g) + "," + DumpUtils.toShortHexString(e) + ")";
                return s;
            }
            case 29: {
                float[] floats = (float[])this.getValue(index);
                String s = "";
                int len = floats.length;
                if (len > 2) {
                    len = 2;
                }
                for (int i = 0; i < len; ++i) {
                    s = i != len - 1 ? s + floats[i] + ";" : s + floats[i];
                }
                if (floats.length > 2) {
                    s = s + ";...";
                }
                return s;
            }
            case 31: {
                double[] doubles = (double[])this.getValue(index);
                String s = "";
                int len = doubles.length;
                if (len > 2) {
                    len = 2;
                }
                for (int i = 0; i < len; ++i) {
                    s = i != len - 1 ? s + doubles[i] + ";" : s + doubles[i];
                }
                if (doubles.length > 2) {
                    s = s + ";...";
                }
                return s;
            }
        }
        return null;
    }

    public void setString(String s, int index) throws DicomException {
        if (s == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.setValue(this.fromString(s), index);
    }

    public void addString(String s) throws DicomException {
        if (s == null) {
            throw new DicomException("String argument in addString cannot be null. Use \"\" to insert an empty String");
        }
        this.addValue(this.fromString(s));
    }

    public void setString(String s, int index, DicomCharset dicomCharset) throws DicomException {
        if (s == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.setValue(this.fromString(s, new DicomCharset[]{dicomCharset}), index);
    }

    public void addString(String s, DicomCharset dicomCharset) throws DicomException {
        if (s == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.addValue(this.fromString(s, new DicomCharset[]{dicomCharset}));
    }

    private Object fromString(String s, DicomCharset[] dicomCharsets) throws DicomException {
        switch (this.dcm_type) {
            case 6: 
            case 7: 
            case 13: 
            case 18: 
            case 27: 
            case 32: {
                return Jdt.getCharsetCoder().encode(s, dicomCharsets);
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 28: 
            case 33: {
                return Jdt.getCharsetCoder().encode(s);
            }
            case 17: {
                if (s.length() != 0 && s.length() != 4) {
                    throw new DicomException("Type AS has to have 4 bytes fixed.");
                }
                return Jdt.getCharsetCoder().encode(s);
            }
            case 14: {
                return Jdt.getCharsetCoder().encode(s, dicomCharsets);
            }
            case 11: {
                return Jdt.getCharsetCoder().encode(s);
            }
            case 16: {
                if (Jdt.isDSAsString()) {
                    return Jdt.getCharsetCoder().encode(s);
                }
                return new Float(s);
            }
            case 26: {
                return new Float(s);
            }
            case 15: {
                return Jdt.getCharsetCoder().encode(s);
            }
            case 23: {
                return new Short(s);
            }
            case 3: 
            case 21: {
                return new Integer(s);
            }
            case 1: 
            case 19: {
                return new Long(s);
            }
            case 35: 
            case 36: {
                return new BigInteger(s);
            }
            case 20: {
                return new Double(s);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                return new ByteArray(new byte[][]{s.getBytes()});
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element from java.lang.String");
    }

    private Object fromString(String s) throws DicomException {
        return this.fromString(s, this.dcm.dicomCharsets());
    }

    public Short getShort(int index) throws DicomException {
        switch (this.getVR()) {
            case 23: {
                return (Short)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Short");
    }

    public void setShort(Short sh, int index) throws DicomException {
        if (sh == null && this.getVR() != 15) {
            throw new DicomException("Short argument can only be null for data elements of VR IS");
        }
        this.setValue(this.fromShort(sh), index);
    }

    public void addShort(Short sh) throws DicomException {
        if (sh == null && this.getVR() != 15) {
            throw new DicomException("Short argument can only be null for data elements of VR IS");
        }
        this.addValue(this.fromShort(sh));
    }

    private Object fromShort(Short sh) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                DataElement.checkBounds(sh.longValue(), 0L, 0xFFFFFFFFL, 1);
                return new Long(sh.longValue());
            }
            case 19: {
                return new Long(sh.longValue());
            }
            case 3: {
                DataElement.checkBounds(sh.longValue(), 0L, 65535L, 3);
                return new Integer(sh.intValue());
            }
            case 23: {
                return sh;
            }
            case 15: {
                if (sh == null) {
                    return new byte[0];
                }
                DataElement.checkBounds(sh.longValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(sh.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Short");
    }

    public Integer getInteger(int index) throws DicomException {
        switch (this.getVR()) {
            case 15: {
                byte[] ar = (byte[])this.getValue(index);
                int[] pos = ConvertUtils.trim(ar, this.getVR());
                String s = Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                s = s.startsWith("+") ? s.substring(1) : s;
                return Integer.valueOf(s, 10);
            }
            case 19: {
                return ((Long)this.getValue(index)).intValue();
            }
            case 3: 
            case 21: {
                return (Integer)this.getValue(index);
            }
            case 23: {
                return ((Short)this.getValue(index)).intValue();
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public void setInteger(Integer i, int index) throws DicomException {
        if (i == null && this.getVR() != 15) {
            throw new DicomException("Integer argument can only be null for data elements of VR IS");
        }
        this.setValue(this.fromInteger(i), index);
    }

    public void addInteger(Integer i) throws DicomException {
        if (i == null && this.getVR() != 15) {
            throw new DicomException("Integer argument can only be null for data elements of VR IS");
        }
        this.addValue(this.fromInteger(i));
    }

    private Object fromInteger(Integer i) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                DataElement.checkBounds(i.longValue(), 0L, 0xFFFFFFFFL, 1);
                return new Long(i.longValue());
            }
            case 19: {
                return new Long(i.longValue());
            }
            case 3: {
                DataElement.checkBounds(i.longValue(), 0L, 65535L, 3);
                return i;
            }
            case 23: {
                DataElement.checkBounds(i.longValue(), -32768L, 32767L, 23);
                return new Short(i.shortValue());
            }
            case 15: {
                if (i == null) {
                    return new byte[0];
                }
                DataElement.checkBounds(i.longValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(i.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public Long getLong(int index) throws DicomException {
        switch (this.getVR()) {
            case 15: {
                byte[] ar = (byte[])this.getValue(index);
                int[] pos = ConvertUtils.trim(ar, this.getVR());
                String s = Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                return Long.valueOf(s, 10);
            }
            case 1: 
            case 19: {
                return (Long)this.getValue(index);
            }
            case 3: {
                return new Long(((Integer)this.getValue(index)).intValue());
            }
            case 23: {
                return new Long(((Short)this.getValue(index)).intValue());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public void setLong(Long l, int index) throws DicomException {
        if (l == null && this.getVR() != 15) {
            throw new DicomException("Long argument can only be null for data elements of VR IS");
        }
        this.setValue(this.fromLong(l), index);
    }

    public void addLong(Long l) throws DicomException {
        if (l == null && this.getVR() != 15) {
            throw new DicomException("Long argument can only be null for data elements of VR IS");
        }
        this.addValue(this.fromLong(l));
    }

    private Object fromLong(Long l) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                DataElement.checkBounds(l, 0L, 0xFFFFFFFFL, 1);
                return l;
            }
            case 19: {
                DataElement.checkBounds(l, Integer.MIN_VALUE, Integer.MAX_VALUE, 19);
                return l;
            }
            case 3: {
                DataElement.checkBounds(l, 0L, 65535L, 3);
                return new Integer((int)l.longValue());
            }
            case 23: {
                DataElement.checkBounds(l, -32768L, 32767L, 23);
                return new Short((short)l.longValue());
            }
            case 15: {
                if (l == null) {
                    return new byte[0];
                }
                DataElement.checkBounds(l, Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(l.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public Person getPersonName(int index) throws DicomException {
        switch (this.getVR()) {
            case 14: {
                return new Person(this.getString(index));
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a Person Object");
    }

    public void setPersonName(Person p, int index) throws DicomException {
        this.setValue(this.fromPersonName(p), index);
    }

    public void setPersonName(Person p, int index, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        this.setValue(this.fromPersonName(p, singleByteCharset, ideographicCharset, phoneticCharset), index);
    }

    public void addPersonName(Person p) throws DicomException {
        this.addValue(this.fromPersonName(p));
    }

    public void addPersonName(Person p, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        this.addValue(this.fromPersonName(p, singleByteCharset, ideographicCharset, phoneticCharset));
    }

    private Object fromPersonName(Person p) throws DicomException {
        DicomCharset charset = this.dcm.dicomCharsets()[0];
        return this.fromPersonName(p, charset, charset, charset);
    }

    private Object fromPersonName(Person p, DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomException {
        switch (this.getVR()) {
            case 14: {
                return p.encode(singleByteCharset, ideographicCharset, phoneticCharset);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a Person Object");
    }

    public ByteArray getByteArray(int index) throws DicomException {
        switch (this.getVR()) {
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                return (ByteArray)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as byte array");
    }

    public void setByteArray(ByteArray byteArray, int index) throws DicomException {
        if (byteArray == null) {
            throw new DicomException("byteArray argument cannot be null.");
        }
        this.setValue(this.fromByteArray(byteArray), index);
    }

    public void addByteArray(ByteArray byteArray) throws DicomException {
        if (byteArray == null) {
            throw new DicomException("byte array argument cannot be null.");
        }
        this.addValue(this.fromByteArray(byteArray));
    }

    public Object fromByteArray(ByteArray byteArray) throws DicomException {
        switch (this.getVR()) {
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: {
                return byteArray;
            }
            case 34: {
                try {
                    return DicomDataValidator.getDefault().validateOrThrow(this.getVR(), (Object)byteArray);
                }
                catch (DicomException ex) {
                    throw new DicomException(String.format("unable to represent %s data element as byte array (%s)", DDict.getTypeName(this.getVR()), ex.getMessage()));
                }
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as byte array", DDict.getTypeName(this.getVR())));
    }

    public byte[] getBytes(int index) throws DicomException {
        switch (this.getVR()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                return (byte[])this.getValue(index);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                ByteArray byteArray = (ByteArray)this.getValue(index);
                if (byteArray.arrays() == 1) {
                    return byteArray.getArray(0);
                }
                throw new DicomException("element to large to be represented as a single byte[] array.");
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as byte array");
    }

    public void setBytes(byte[] bytes, int index) throws DicomException {
        if (bytes == null) {
            throw new DicomException("byte array argument cannot be null.");
        }
        this.setValue(this.fromBytes(bytes), index);
    }

    public void addBytes(byte[] bytes) throws DicomException {
        if (bytes == null) {
            throw new DicomException("byte array argument cannot be null.");
        }
        this.addValue(this.fromBytes(bytes));
    }

    public Object fromBytes(byte[] bytes) throws DicomException {
        switch (this.getVR()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                return bytes;
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: {
                return new ByteArray(new byte[][]{bytes});
            }
            case 34: {
                try {
                    return DicomDataValidator.getDefault().validateOrThrow(this.getVR(), (Object)new ByteArray(new byte[][]{bytes}));
                }
                catch (DicomException ex) {
                    throw new DicomException(String.format("unable to represent %s data element as byte array (%s)", DDict.getTypeName(this.getVR()), ex.getMessage()));
                }
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as byte array", DDict.getTypeName(this.getVR())));
    }

    public Float getFloat(int index) throws DicomException {
        switch (this.getVR()) {
            case 26: {
                return (Float)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Float");
    }

    public void setFloat(Float f, int index) throws DicomException {
        if (f == null) {
            throw new DicomException("Float argument cannot be null");
        }
        this.setValue(this.fromFloat(f), index);
    }

    public void addFloat(Float f) throws DicomException {
        if (f == null) {
            throw new DicomException("Float argument cannot be null");
        }
        this.addValue(this.fromFloat(f));
    }

    public Object fromFloat(Float f) throws DicomException {
        switch (this.getVR()) {
            case 26: {
                return f;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Float");
    }

    public Double getDouble(int index) throws DicomException {
        switch (this.getVR()) {
            case 20: {
                return (Double)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Double");
    }

    public void setDouble(Double d, int index) throws DicomException {
        if (d == null) {
            throw new DicomException("Double argument cannot be null");
        }
        this.setValue(this.fromDouble(d), index);
    }

    public void addDouble(Double d) throws DicomException {
        if (d == null) {
            throw new DicomException("Double argument cannot be null");
        }
        this.addValue(this.fromDouble(d));
    }

    public Object fromDouble(Double d) throws DicomException {
        switch (this.getVR()) {
            case 20: {
                return d;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Double");
    }

    public float[] getFloats(int index) throws DicomException {
        switch (this.getVR()) {
            case 29: {
                return (float[])this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as float array");
    }

    public void setFloats(float[] floats, int index) throws DicomException {
        if (floats == null) {
            throw new DicomException("float array argument cannot be null");
        }
        this.setValue(this.fromFloats(floats), index);
    }

    public void addFloats(float[] floats) throws DicomException {
        if (floats == null) {
            throw new DicomException("float array argument cannot be null");
        }
        this.addValue(this.fromFloats(floats));
    }

    public Object fromFloats(float[] floats) throws DicomException {
        switch (this.getVR()) {
            case 29: {
                return floats;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as float array");
    }

    public double[] getDoubles(int index) throws DicomException {
        switch (this.getVR()) {
            case 31: {
                return (double[])this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as double array");
    }

    public void setDoubles(double[] doubles, int index) throws DicomException {
        if (doubles == null) {
            throw new DicomException("double array argument cannot be null");
        }
        this.setValue(this.fromDoubles(doubles), index);
    }

    public void addDoubles(double[] doubles) throws DicomException {
        if (doubles == null) {
            throw new DicomException("double array argument cannot be null");
        }
        this.addValue(this.fromDoubles(doubles));
    }

    public Object fromDoubles(double[] doubles) throws DicomException {
        switch (this.getVR()) {
            case 31: {
                return doubles;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as double array");
    }

    public DicomObject getSequenceItem(int index) throws DicomException {
        switch (this.getVR()) {
            case 10: {
                return (DicomObject)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a DicomObject");
    }

    public void setSequenceItem(DicomObject item, int index) throws DicomException {
        this.setValue(this.fromDicomObject(item), index);
    }

    public void addSequenceItem(DicomObject item) throws DicomException {
        this.addValue(this.fromDicomObject(item));
    }

    public Object fromDicomObject(DicomObject dicomObject) throws DicomException {
        switch (this.getVR()) {
            case 10: {
                dicomObject.setParent(this.dcm);
                return dicomObject;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as DicomObject");
    }

    public ATValue getATValue(int index) throws DicomException {
        switch (this.getVR()) {
            case 5: {
                return (ATValue)this.getValue(index);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a AttributeTag object");
    }

    public void setATValue(ATValue atValue, int index) throws DicomException {
        if (atValue == null) {
            throw new DicomException("ATValue argument cannot be null");
        }
        this.setValue(this.fromATValue(atValue), index);
    }

    public void addATValue(ATValue atValue) throws DicomException {
        if (atValue == null) {
            throw new DicomException("ATValue argument cannot be null");
        }
        this.addValue(this.fromATValue(atValue));
    }

    public Object fromATValue(ATValue atValue) throws DicomException {
        switch (this.getVR()) {
            case 5: {
                return atValue;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as ATValue");
    }

    public BigDecimal getBigDecimal(int index) throws DicomException {
        switch (this.getVR()) {
            case 16: {
                byte[] ar = (byte[])this.getValue(index);
                if (ar == null) {
                    return null;
                }
                int[] pos = ConvertUtils.trim(ar, 16);
                String s = Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], defaultCharsets);
                return s.isEmpty() ? null : new BigDecimal(s);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a java.math.BigDecimal object");
    }

    public void setBigDecimal(BigDecimal bd, int index) throws DicomException {
        this.setValue(this.fromBigDecimal(bd), index);
    }

    public void addBigDecimal(BigDecimal bd) throws DicomException {
        this.addValue(this.fromBigDecimal(bd));
    }

    private Object fromBigDecimal(BigDecimal bd) throws DicomException {
        switch (this.getVR()) {
            case 16: {
                if (bd == null) {
                    return new byte[0];
                }
                return Jdt.getCharsetCoder().encode(bd.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.math.BigDecimal object");
    }

    public BigInteger getBigInteger(int index) throws DicomException {
        switch (this.getVR()) {
            case 35: 
            case 36: {
                return (BigInteger)this.getValue(index);
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as a java.math.BigInteger[] object", DDict.getTypeName(this.getVR())));
    }

    public void setBigInteger(BigInteger bi, int index) throws DicomException {
        if (bi == null) {
            throw new DicomException("BigInteger argument cannot be null.");
        }
        this.setValue(this.fromBigInteger(bi), index);
    }

    public void addBigInteger(BigInteger bi) throws DicomException {
        if (bi == null) {
            throw new DicomException("BigInteger argument cannot be null.");
        }
        this.addValue(this.fromBigInteger(bi));
    }

    private Object fromBigInteger(BigInteger bi) throws DicomException {
        switch (this.getVR()) {
            case 35: {
                DataElement.checkBounds(bi, MIN_SV, MAX_SV, 35);
                return bi;
            }
            case 36: {
                DataElement.checkBounds(bi, MIN_UV, MAX_UV, 36);
                return bi;
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as a java.math.BigInteger object", DDict.getTypeName(this.getVR())));
    }

    public BulkDataReference getBulkDataReference(int index) throws DicomException {
        switch (this.getVR()) {
            case 0: 
            case 1: 
            case 3: 
            case 8: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                Object value = this.getValue(index);
                if (value instanceof BulkDataReference) {
                    return (BulkDataReference)value;
                }
                throw new DicomException(String.format("Value stored in element is not of type BulkDataReference but %s", value.getClass().getName()));
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as BulkDataReference.", DDict.getTypeName(this.getVR())));
    }

    public void setBulkDataReference(BulkDataReference bulkDataReference, int index) throws DicomException {
        if (bulkDataReference == null) {
            throw new DicomException("bulkDataReference argument cannot be null.");
        }
        this.setValue(this.fromBulkDataReference(bulkDataReference), index);
    }

    public void addBulkDataReference(BulkDataReference bulkDataReference) throws DicomException {
        if (bulkDataReference == null) {
            throw new DicomException("bulkDataReference argument cannot be null.");
        }
        this.addValue(this.fromBulkDataReference(bulkDataReference));
    }

    private Object fromBulkDataReference(BulkDataReference bulkDataReference) throws DicomException {
        switch (this.getVR()) {
            case 0: 
            case 1: 
            case 3: 
            case 8: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                return bulkDataReference;
            }
        }
        throw new DicomException(String.format("unable to represent %s data element as BulkDataReference", DDict.getTypeName(this.getVR())));
    }

    private static void checkBounds(long l, long min, long max, int t) throws DicomException {
        if (l < min || l > max) {
            throw new DicomException("unable to store " + l + " as " + DDict.getTypeName(t) + ": value out of bound [" + min + "," + max + "]");
        }
    }

    private static void checkBounds(BigInteger bi, BigInteger min, BigInteger max, int t) throws DicomException {
        if (bi.compareTo(min) < 0 || bi.compareTo(max) > 0) {
            throw new DicomException("unable to store " + bi + " as " + DDict.getTypeName(t) + ": value out of bound [" + min + "," + max + "]");
        }
    }
}

