/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.MultiVRInputStream;
import com.archimed.dicom.SequenceItemReadEvent;
import com.archimed.dicom.SequenceItemReadListener;
import com.archimed.dicom.TagRead2Listener;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.VR;
import com.archimed.log.JdtLogger;
import com.archimed.tool.IOUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DicomReader {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomReader.class);
    private Map<Integer, List<TagReadListener>> tagReadListeners = new HashMap<Integer, List<TagReadListener>>();
    private HashMap<Integer, List<SequenceItemReadListener>> sequenceItemReadListeners = new HashMap();

    public void addTagReadListener(TagReadListener listener, int tag2) {
        this.addTagReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void addTagReadListener(TagReadListener listener, int group, int element) {
        Integer key = group * 65535 + element;
        List<TagReadListener> v = this.tagReadListeners.get(key);
        if (v == null) {
            v = new ArrayList<TagReadListener>();
            this.tagReadListeners.put(key, v);
        }
        v.add(listener);
    }

    public synchronized void addTagReadListener(TagReadListener listener) {
        List<TagReadListener> v = this.tagReadListeners.get(null);
        if (v == null) {
            v = new ArrayList<TagReadListener>();
            this.tagReadListeners.put(null, v);
        }
        v.add(listener);
    }

    public synchronized void removeTagReadListener(TagReadListener listener, int tag2) {
        this.removeTagReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void removeTagReadListener(TagReadListener listener, int group, int element) {
        Integer key = group * 65535 + element;
        List<TagReadListener> v = this.tagReadListeners.get(key);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public synchronized void removeTagReadListener(TagReadListener listener) {
        List<TagReadListener> v = this.tagReadListeners.get(null);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public void addSequenceItemReadListener(SequenceItemReadListener listener, int tag2) {
        this.addSequenceItemReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void addSequenceItemReadListener(SequenceItemReadListener listener, int group, int element) {
        Integer key = group * 65535 + element;
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(key);
        if (v == null) {
            v = new ArrayList<SequenceItemReadListener>();
            this.sequenceItemReadListeners.put(key, v);
        }
        v.add(listener);
    }

    public synchronized void addSequenceItemReadListener(SequenceItemReadListener listener) {
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(null);
        if (v == null) {
            v = new ArrayList<SequenceItemReadListener>();
            this.sequenceItemReadListeners.put(null, v);
        }
        v.add(listener);
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener, int tag2) {
        this.removeSequenceItemReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener, int group, int element) {
        Integer key = group * 65535 + element;
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(key);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener) {
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(null);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public DicomObject read(InputStream in) throws IOException, DicomException {
        DicomObject dcm = new DicomObject();
        this.read(dcm, in);
        return dcm;
    }

    public DicomObject read(InputStream in, boolean readpixels) throws IOException, DicomException {
        if (!readpixels) {
            this.addTagReadListener(new TagReadListener(){

                @Override
                public void afterHeader(TagReadEvent e) {
                    if (e.getDataReadStatus() == 3) {
                        return;
                    }
                    e.setDataReadStatus(e.getDicomObject().getParent() == null ? 2 : 0);
                }
            }, 2145386512);
        }
        DicomObject dcm = new DicomObject();
        this.read(dcm, in);
        return dcm;
    }

    public DicomObject read(InputStream in, int transfersyntax) throws IOException, DicomException {
        DicomObject dcm = new DicomObject();
        MultiVRInputStream multiVRIn = new MultiVRInputStream(in);
        this.readDICOMStream(dcm, multiVRIn, transfersyntax);
        return dcm;
    }

    public DicomObject read(InputStream in, int transfersyntax, boolean readpixels) throws IOException, DicomException {
        if (!readpixels) {
            this.addTagReadListener(new TagReadListener(){

                @Override
                public void afterHeader(TagReadEvent e) {
                    e.setDataReadStatus(e.getDicomObject().getParent() == null ? 2 : 0);
                }
            }, 2145386512);
        }
        DicomObject dcm = new DicomObject();
        MultiVRInputStream multiVRIn = new MultiVRInputStream(in);
        this.readDICOMStream(dcm, multiVRIn, transfersyntax);
        return dcm;
    }

    public DicomObject readSequenceItem(InputStream in, int transferSyntax) throws IOException, DicomException {
        MultiVRInputStream multiVRin = new MultiVRInputStream(in);
        multiVRin.setTransferSyntax(transferSyntax);
        int group = multiVRin.readUInt16();
        int element = multiVRin.readUInt16();
        if (group != 65534 || element != 57344) {
            throw new DicomException("illegal value for group,element tag, expecting (FFFE,E000)");
        }
        DicomObject parent = new DicomObject();
        VR vr2 = new VR(parent);
        return vr2.readOrphanedSequenceItem(parent, this, multiVRin, -1);
    }

    TagReadEvent fireAfterReadHeader(DataElement dataElement, InputStream in, long offset) {
        Integer key;
        boolean hasListeners = false;
        TagReadEvent e = new TagReadEvent(dataElement, in, offset);
        List<TagReadListener> v = this.tagReadListeners.get(null);
        if (v != null && v.size() > 0) {
            hasListeners = true;
            for (TagReadListener aV : v) {
                aV.afterHeader(e);
            }
        }
        if ((v = this.tagReadListeners.get(key = Integer.valueOf(dataElement.getGroup() * 65535 + dataElement.getElement()))) != null && v.size() > 0) {
            hasListeners = true;
            for (TagReadListener aV : v) {
                aV.afterHeader(e);
            }
        }
        return hasListeners ? e : null;
    }

    TagReadEvent fireAfterReadData(TagReadEvent e) {
        List<TagReadListener> v = this.tagReadListeners.get(null);
        boolean hasListeners = this.fireAfterReadData(e, v, false);
        Integer key = e.getGroup() * 65535 + e.getElement();
        v = this.tagReadListeners.get(key);
        hasListeners = this.fireAfterReadData(e, v, hasListeners);
        return hasListeners ? e : null;
    }

    private boolean fireAfterReadData(TagReadEvent e, List<TagReadListener> tagReadListeners, boolean hasListeners) {
        if (tagReadListeners != null && tagReadListeners.size() > 0) {
            for (TagReadListener tagReadListener : tagReadListeners) {
                if (!TagRead2Listener.class.isAssignableFrom(tagReadListener.getClass())) continue;
                hasListeners = true;
                ((TagRead2Listener)tagReadListener).afterData(e);
            }
        }
        return hasListeners;
    }

    void fireBeforeReadSequenceItem(DataElement dataElement, DicomObject sequenceItem, MultiVRInputStream in, int itemIndex) {
        Integer key;
        SequenceItemReadEvent e = new SequenceItemReadEvent(dataElement, sequenceItem, in, itemIndex);
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(null);
        if (v != null && v.size() > 0) {
            for (SequenceItemReadListener aV : v) {
                aV.beforeSequenceItem(e);
            }
        }
        if ((v = this.sequenceItemReadListeners.get(key = Integer.valueOf(dataElement.getGroup() * 65535 + dataElement.getElement()))) != null && v.size() > 0) {
            for (SequenceItemReadListener aV : v) {
                aV.beforeSequenceItem(e);
            }
        }
    }

    void fireAfterReadSequenceItem(DataElement dataElement, DicomObject sequenceItem, MultiVRInputStream in, int itemIndex) {
        Integer key;
        SequenceItemReadEvent e = new SequenceItemReadEvent(dataElement, sequenceItem, in, itemIndex);
        List<SequenceItemReadListener> v = this.sequenceItemReadListeners.get(null);
        if (v != null && v.size() > 0) {
            for (SequenceItemReadListener aV : v) {
                aV.afterSequenceItem(e);
            }
        }
        if ((v = this.sequenceItemReadListeners.get(key = Integer.valueOf(dataElement.getGroup() * 65535 + dataElement.getElement()))) != null && v.size() > 0) {
            for (SequenceItemReadListener aV : v) {
                aV.afterSequenceItem(e);
            }
        }
    }

    void read(DicomObject dcm, InputStream in) throws IOException, DicomException {
        boolean df;
        InputStream bis = in.markSupported() ? in : new BufferedInputStream(in);
        bis.mark(256);
        try {
            df = this.checkIfDicomFile(bis);
        }
        catch (Exception e) {
            df = false;
        }
        bis.reset();
        MultiVRInputStream multiVRInputStream = new MultiVRInputStream(bis);
        if (df) {
            long offset = this.readHeader(dcm, multiVRInputStream);
            if (offset == -1L) {
                return;
            }
            this.readDICOMStream(dcm, multiVRInputStream, 8193);
        } else {
            this.readDICOMStream(dcm, multiVRInputStream, 8193);
        }
    }

    public static DicomObject readFileMetaInformation(InputStream in) throws IOException, DicomException {
        DicomObject filemetainfo = new DicomObject();
        MultiVRInputStream multiVRIn = new MultiVRInputStream(in);
        while (true) {
            VR vr2 = new VR(filemetainfo);
            if (in.markSupported()) {
                in.mark(4);
            }
            int group = multiVRIn.readUInt16();
            multiVRIn.unreadUInt16(group);
            if (group != 2) {
                if (!in.markSupported()) break;
                in.reset();
                break;
            }
            vr2.readVR(filemetainfo, new DicomReader(), multiVRIn);
            filemetainfo.push(vr2);
        }
        return filemetainfo;
    }

    public static byte[] readPreamble(InputStream in) throws IOException, DicomException {
        try {
            byte[] preamble = new byte[128];
            IOUtil.readFully(in, preamble);
            if (!Arrays.equals(new byte[]{68, 73, 67, 77}, IOUtil.readFully(in, 4))) {
                throw new DicomException("not a valid DICOM file header");
            }
            return preamble;
        }
        catch (EOFException ex) {
            throw new DicomException("not a valid DICOM file header (end-of-stream)");
        }
    }

    public boolean checkIfDicomFile(InputStream f) throws IOException, DicomException {
        byte[] preamble = new byte[128];
        byte[] hdr = new byte[4];
        DataInputStream is = new DataInputStream(f);
        try {
            is.readFully(preamble);
            is.readFully(hdr);
        }
        catch (EOFException ex) {
            this.log.warn("EOFException before reading 132 bytes: not a DICOM file");
            return false;
        }
        return new String(hdr).equals("DICM");
    }

    void readDICOMStream(DicomObject dcm, MultiVRInputStream multiVRIn, int ts) throws IOException, DicomException {
        boolean guessingTransferSyntax = false;
        this.log.debug("DicomObject.readDICOMStream.");
        DicomObject filemetainfo = dcm.getFileMetaInformation();
        if (filemetainfo != null) {
            if (filemetainfo.getSize(131088) > 0) {
                try {
                    ts = UID.getUIDEntry(filemetainfo.getString(131088, 0).trim()).getConstant();
                }
                catch (UnknownUIDException e) {
                    this.log.warn(String.format("received unknown transfer syntax %s, continuing with PrivateTransferSyntax", filemetainfo.getString(131088, 0)));
                    ts = 8192;
                }
            } else {
                this.log.warn("transfer syntax missing from file meta information (group 0x0002), trying to detect transfer syntax in stream");
                ts = this.guessTransferSyntax(multiVRIn);
                this.log.warn(String.format("guessed transfer syntax to be %s", TransferSyntax.get(ts).getValue()));
                guessingTransferSyntax = true;
            }
        }
        multiVRIn.setTransferSyntax(ts);
        this.readTags(dcm, multiVRIn);
        if (ts == 8193 || ts == 8227) {
            this.adjustTypes(dcm);
        }
        if (guessingTransferSyntax) {
            this.correctFileMetaInformation(dcm, ts);
        }
    }

    long readHeader(DicomObject dcm, MultiVRInputStream multiVRIn) throws IOException, DicomException {
        this.log.debug("DicomObject.readHeader.");
        byte[] preamble = new byte[128];
        byte[] hdr = new byte[4];
        multiVRIn.setTransferSyntax(8194);
        multiVRIn.readFully(preamble);
        dcm.setPreamble(preamble);
        multiVRIn.readFully(hdr);
        if (hdr[0] != 68 || hdr[1] != 73 || hdr[2] != 67 || hdr[3] != 77) {
            throw new DicomException("Not a valid DICOM file: missing DICM characters at offset 128");
        }
        DicomObject filemetainfo = new DicomObject();
        dcm.setFileMetaInformation(filemetainfo);
        int futureTS = 8192;
        while (true) {
            VR vr2 = new VR(filemetainfo);
            int group = multiVRIn.readUInt16();
            multiVRIn.unreadUInt16(group);
            if (group != 2) break;
            int readState = vr2.readVR(filemetainfo, this, multiVRIn);
            if (vr2.getGroup() != 2) {
                if (this.handleVR(dcm, vr2, readState)) break;
                return -1L;
            }
            if (!this.handleVR(filemetainfo, vr2, readState)) {
                return -1L;
            }
            if (vr2.getGroup() != 2 || vr2.getElement() != 16) continue;
            try {
                String s = filemetainfo.getS(131088);
                if (s == null) {
                    throw new DicomException("missing Transfer Syntax UID data element in file meta information");
                }
                futureTS = UID.getUIDEntry(s.trim()).getConstant();
            }
            catch (UnknownUIDException e) {
                multiVRIn.setTransferSyntax(8192);
            }
        }
        multiVRIn.setTransferSyntax(futureTS);
        return multiVRIn.getOffset();
    }

    /*
     * Exception decompiling
     */
    void readTags(DicomObject dcm, MultiVRInputStream is) throws IOException, DicomException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean handleVR(DicomObject dcm, VR vr2, int readState) {
        switch (readState) {
            case 1: {
                dcm.push(vr2);
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                dcm.push(vr2);
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    private void adjustTypes(DicomObject dcm) {
        this.adjustToOW(dcm, 2145386512);
        this.adjustToOW(dcm, 1409290256);
        this.adjustToOW(dcm, 2626049);
        this.adjustToOW(dcm, 2626050);
        this.adjustToOW(dcm, 2626051);
        this.adjustToOW(dcm, 0x281221);
        this.adjustToOW(dcm, 0x281222);
        this.adjustToOW(dcm, 2626083);
        for (int g = 0; g <= 30; g += 2) {
            this.adjustType(dcm, 24576 + g, 12288, 24);
            this.adjustType(dcm, 20480 + g, 12288, 8);
            VR vr2 = dcm.getVR(20480 + g, 8194);
            if (vr2 != null && vr2.getValue() != null && (Integer)vr2.getValue() == 0) {
                this.adjustType(dcm, 20480, 8204, 24);
                continue;
            }
            this.adjustType(dcm, 20480, 8204, 8);
        }
    }

    private void adjustToOW(DicomObject dcm, int dct) {
        int group = DDict.getGroup(dct);
        int element = DDict.getElement(dct);
        this.adjustType(dcm, group, element, 24);
    }

    private void adjustType(DicomObject dcm, int group, int element, int vrtype) {
        VR vr2 = dcm.getVR(group, element);
        if (vr2 != null && vr2.dcm_type == 22) {
            vr2.dcm_type = vrtype;
        }
    }

    private int guessTransferSyntax(MultiVRInputStream multiVRInputStream) throws IOException {
        multiVRInputStream.setTransferSyntax(8194);
        int group = multiVRInputStream.readUInt16();
        int element = multiVRInputStream.readUInt16();
        String vrType = multiVRInputStream.readString(2);
        multiVRInputStream.unread(vrType.getBytes(StandardCharsets.UTF_8));
        multiVRInputStream.unreadUInt16(element);
        multiVRInputStream.unreadUInt16(group);
        if (group == 2048) {
            this.log.warn("read 00 08 in Big Endian -> guessing EBE");
            return 8195;
        }
        if (group != 8) {
            this.log.warn("expecting first two bytes of stream either 00 08 or 08 00, giving up");
            return 8192;
        }
        this.log.warn(String.format("read %s in Little Endian -> ILE or ELE or encapsulated, checking VR type %s with dictionary ", DumpUtils.tagString(group, element), vrType));
        int dct = DDict.lookupDDict(group, element);
        if (dct == -1) {
            this.log.warn(String.format("data element %s not defined in public dictionary, giving up.", DumpUtils.tagString(group, element)));
            return 8192;
        }
        if (!vrType.equals(DDict.getTypeCodeName(dct))) {
            this.log.warn(String.format("VR (%s) of data element %s does not match VR read (%s), guessing ILE", DDict.getTypeCodeName(dct), DumpUtils.tagString(group, element), vrType));
            return 8193;
        }
        this.log.warn(String.format("VR (%s) of data element %s matches VR read (%s), guessing ELE (Might still be encapsulated)", DDict.getTypeCodeName(dct), DumpUtils.tagString(group, element), vrType));
        return 8194;
    }

    private void correctFileMetaInformation(DicomObject dcm, int ts) throws DicomException {
        DataElement topLevelPixelData;
        byte[] metainfo = new byte[]{0, 1};
        DicomObject filemetainfo = dcm.getFileMetaInformation();
        if (filemetainfo == null) {
            filemetainfo = new DicomObject();
            filemetainfo.setBytes(131073, metainfo, 0);
            dcm.setFileMetaInformation(filemetainfo);
        }
        if (filemetainfo.getSize(131073) <= 0) {
            filemetainfo.setBytes(131073, metainfo, 0);
        }
        if (filemetainfo.getSize(131074) <= 0 && dcm.getSize(524310) > 0) {
            filemetainfo.set(131074, dcm.getString(524310, 0), 0);
            this.log.warn(String.format("file meta information Media Storage SOP Class UID added: %s", dcm.getString(524310, 0)));
        }
        if (filemetainfo.getSize(131075) <= 0 && dcm.getSize(524312) > 0) {
            filemetainfo.set(131075, dcm.getString(524312, 0), 0);
            this.log.warn(String.format("file meta information Media Storage SOP Instance UID added: %s", dcm.getString(524312, 0)));
        }
        if (filemetainfo.getSize(131088) <= 0) {
            filemetainfo.set(131088, TransferSyntax.get(ts).getValue(), 0);
            this.log.warn(String.format("file meta information Transfer Syntax added: %s", TransferSyntax.get(ts).getValue()));
        }
        if ((topLevelPixelData = dcm.getDataElement(2145386512)) != null && topLevelPixelData.getValueLengthAsLong() == 0xFFFFFFFFL) {
            this.log.warn("Corrected transfer syntax propably incorrect: length of pixeldata is undefined indicating an encapsulated transfer syntax");
        }
    }
}

