/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.BulkDataReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileBulkDataReference
implements BulkDataReference {
    private Path path;
    private ByteOrder byteOrder;
    private long length = -1L;
    private InputStream resolvedInputStream = null;

    public FileBulkDataReference(Path path) {
        this.path = path;
        this.byteOrder = ByteOrder.nativeOrder();
    }

    public FileBulkDataReference(Path path, ByteOrder byteOrder) {
        this.path = path;
        this.byteOrder = byteOrder;
    }

    @Override
    public void resolve() throws IOException {
        this.length = Files.size(this.path);
        this.resolvedInputStream = Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public InputStream getInputStream() {
        return this.resolvedInputStream;
    }

    @Override
    public void release() throws IOException {
        this.resolvedInputStream.close();
    }

    @Override
    public String getDescription() {
        return String.format("FBDR: %s", this.path.getFileName());
    }
}

