/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.LengthUtils;
import com.archimed.dicom.VR;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class GroupList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Map<Integer, VR>> groups = new HashMap<Integer, Map<Integer, VR>>();

    void push(VR vr2) {
        if (vr2 == null) {
            return;
        }
        Map<Integer, VR> ge = this.groups.get(vr2.group);
        if (ge == null) {
            ge = new HashMap<Integer, VR>();
            this.groups.put(vr2.group, ge);
        }
        ge.put(vr2.element, vr2);
    }

    public void clear() {
        for (Map.Entry<Integer, Map<Integer, VR>> entry : this.groups.entrySet()) {
            entry.getValue().clear();
        }
        this.groups.clear();
    }

    VR getVR(int g, int e) {
        Map<Integer, VR> ge = this.groups.get(g);
        if (ge == null) {
            return null;
        }
        return ge.get(e);
    }

    VR removeVR(int g, int e) {
        if (!this.groups.containsKey(g)) {
            return null;
        }
        return this.groups.get(g).remove(e);
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public Enumeration enumerateVRs(boolean grouplens) {
        return this.enumerateVRs(grouplens, 8193, true);
    }

    Enumeration enumerateVRs(boolean grouplens, int ts, boolean seq_undef) {
        return this.enumerateVRs(ts, seq_undef ? 8200 : 8201, grouplens ? 2 : 1);
    }

    public Enumeration enumerateVRs(int ts, int seqLengthOpt, int groupLengthOpt) {
        ArrayList<Integer> groupsList = new ArrayList<Integer>();
        ArrayList<VR> vrList = new ArrayList<VR>();
        this.updateLengths(ts, seqLengthOpt, groupLengthOpt);
        for (Integer group : this.groups.keySet()) {
            groupsList.add(group);
        }
        Collections.sort(groupsList);
        for (Integer group : groupsList) {
            ArrayList<Integer> elementsList = new ArrayList<Integer>();
            for (Integer element : this.groups.get(group).keySet()) {
                elementsList.add(element);
            }
            Collections.sort(elementsList);
            for (Integer element : elementsList) {
                vrList.add(this.groups.get(group).get(element));
            }
        }
        return Collections.enumeration(vrList);
    }

    private void updateLengths(int ts, int seqLengthOpt, int groupLengthOpt) {
        VR vr2;
        for (Map.Entry<Integer, Map<Integer, VR>> groupEntry : this.groups.entrySet()) {
            Integer gnr = groupEntry.getKey();
            int transyn = gnr == 2 ? 8194 : ts;
            for (Map.Entry<Integer, VR> elementEntry : groupEntry.getValue().entrySet()) {
                vr2 = elementEntry.getValue();
                if (vr2.element == 0) continue;
                vr2.dataLen = LengthUtils.calculateDataLength(vr2, vr2.dcm_type, transyn, seqLengthOpt, groupLengthOpt);
                vr2.headerLen = LengthUtils.calculateHeaderLength(vr2.dcm_type, transyn);
            }
        }
        for (Map.Entry<Integer, Map<Integer, VR>> groupEntry : this.groups.entrySet()) {
            VR glVR = groupEntry.getValue().get(0);
            if (groupLengthOpt == 1) {
                groupEntry.getValue().remove(0);
                continue;
            }
            if (groupLengthOpt != 2 && (groupLengthOpt != 3 || glVR == null)) continue;
            int glen = 0;
            for (Map.Entry<Integer, VR> elementEntry : groupEntry.getValue().entrySet()) {
                vr2 = elementEntry.getValue();
                if (vr2.element == 0) continue;
                glen = (int)((long)glen + ((long)vr2.headerLen + vr2.dataLen));
            }
            groupEntry.getValue().put(0, new VR((DicomObject)this, groupEntry.getKey(), 0, 1, glen, 4));
        }
    }

    public DicomObject copyGroup(int groupnr) {
        DicomObject dcmObj = new DicomObject();
        Map<Integer, VR> ght = this.groups.get(groupnr);
        if (ght == null) {
            return null;
        }
        for (Map.Entry<Integer, VR> entry : ght.entrySet()) {
            dcmObj.push(entry.getValue());
        }
        return dcmObj;
    }

    public DicomObject removeGroup(int groupnr) {
        DicomObject dcmObj = new DicomObject();
        if (this.groups == null) {
            return null;
        }
        Map<Integer, VR> ght = this.groups.get(groupnr);
        if (ght == null) {
            return null;
        }
        for (Map.Entry<Integer, VR> entry : ght.entrySet()) {
            dcmObj.push(entry.getValue());
        }
        this.groups.remove(groupnr);
        System.gc();
        return dcmObj;
    }

    public boolean containsGroup(int groupnr) {
        return this.groups.containsKey(groupnr);
    }

    void addGroup(DicomObject o) {
        for (Map.Entry<Integer, Map<Integer, VR>> entry : o.groups.entrySet()) {
            if (this.containsGroup(entry.getKey())) continue;
            this.groups.put(entry.getKey(), entry.getValue());
        }
    }

    public void addGroups(DicomObject o) {
        for (Map.Entry<Integer, Map<Integer, VR>> entry : o.groups.entrySet()) {
            DicomObject tmp = o.copyGroup(entry.getKey());
            this.addGroup(tmp);
        }
    }

    public int numberOfGroups() {
        return this.groups.size();
    }

    public int numberOfElements() {
        int len = 0;
        for (Map.Entry<Integer, Map<Integer, VR>> entry : this.groups.entrySet()) {
            len += entry.getValue().size();
        }
        return len;
    }
}

