/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class JdtBuild {
    private static JdtLogger LOG = Jdt.getJdtLoggerFactory().getJdtLogger(JdtBuild.class);
    private static String major;
    private static String minor;
    private static int build;
    private static long buildTime;
    private static String branch;

    private static final String getImplementationVersionThroughPackage() {
        return JdtBuild.class.getPackage().getImplementationVersion();
    }

    private static final String getImplementationVersionFromManifestResource() {
        try {
            ClassLoader classLoader = JdtBuild.class.getClassLoader();
            Enumeration<URL> resources = JdtBuild.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resourceURL = resources.nextElement();
                Manifest manifest = new Manifest(resourceURL.openStream());
                Attributes attr = manifest.getMainAttributes();
                if (attr == null || attr.getValue("Jdt-Implementation-Version") == null) continue;
                return attr.getValue("Jdt-Implementation-Version");
            }
        }
        catch (Throwable th) {
            LOG.error(String.format("Exception while obtaining Implementation-Version attribute from META-INF/MANIFEST.MF directly: %s", th + ""), th);
        }
        return null;
    }

    private static String getImplementationVersionFromVersionClass() throws Exception {
        Class<?> versionClass = Class.forName("com.archimed.dicom.JdtVersion");
        return (String)versionClass.getDeclaredField("_version").get(null);
    }

    private JdtBuild() {
    }

    static String getMajorVersion() {
        return major;
    }

    static String getMinorVersion() {
        return minor;
    }

    static int getBuild() {
        return build;
    }

    static long getBuildTime() {
        return buildTime;
    }

    static String getBranch() {
        return branch;
    }

    static {
        if (major == null) {
            String implementationVersion = null;
            try {
                implementationVersion = JdtBuild.getImplementationVersionFromVersionClass();
            }
            catch (Throwable ex) {
                LOG.debug("Unable to retrieve version from JdtVersion class, retrieving it from package");
            }
            if (implementationVersion == null && (implementationVersion = JdtBuild.getImplementationVersionThroughPackage()) == null) {
                LOG.debug("Unable to retrieve 'Implementation-Version' attribute from package, retrieving it directly from manifest");
                implementationVersion = JdtBuild.getImplementationVersionFromManifestResource();
                if (implementationVersion == null) {
                    LOG.debug("Unable to retrieve 'Jdt-Implementation-Version' attribute directly from manifest. Using 9.99.9999");
                }
            }
            if (implementationVersion != null) {
                String[] s = implementationVersion.split("\\.");
                if (s.length < 3) {
                    throw new RuntimeException("Unable to determine JDT version from manifest: " + implementationVersion);
                }
                major = s[0];
                minor = s[1];
                int index = s[2].indexOf(45);
                if (index == -1) {
                    throw new RuntimeException("Unable to determine JDT version from manifest, no branch: " + implementationVersion);
                }
                String buildS = s[2].substring(0, index);
                build = Integer.parseInt(buildS);
                if (s[2].length() < index + 2) {
                    throw new RuntimeException("Unable to determine JDT version from manifest, no branch after dash: " + implementationVersion);
                }
                branch = s[2].substring(index + 1);
                buildTime = Long.parseLong(s[3]);
            } else {
                major = "9";
                minor = "99";
                build = 9999;
                branch = "nobranch";
                buildTime = 0L;
            }
        }
    }
}

