/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SingleVRInputStream;
import com.archimed.dicom.VR;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.charset.DicomCharsetCoder;
import com.archimed.log.JdtLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiVRInputStream
extends SingleVRInputStream {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(MultiVRInputStream.class);
    private static final byte DELIMITER = 92;

    MultiVRInputStream(InputStream in) {
        super(in);
    }

    private List readFixed(int dcm_type, long num, long maxReadLength, VR.ReadState readState) throws IOException {
        long valuesToRead = maxReadLength == 0L ? num : Math.min(num, maxReadLength / (long)DDictBase.getValueLength(dcm_type) + 1L);
        long valuesToSkip = maxReadLength == 0L ? 0L : num - valuesToRead;
        long bytesToSkip = valuesToSkip * (long)DDictBase.getValueLength(dcm_type);
        ArrayList<Object> v = new ArrayList<Object>();
        for (long i = 0L; i < valuesToRead; ++i) {
            v.add(this.readFixed(dcm_type));
        }
        if (valuesToSkip > 0L) {
            this.skipBytes(bytesToSkip);
        }
        readState.setBytesSkipped(bytesToSkip);
        return v;
    }

    private List readSingleByteArray(long len, long maxReadLength, VR.ReadState readState) throws IOException {
        ArrayList<byte[]> v = new ArrayList<byte[]>();
        long bytesToRead = maxReadLength <= 0L ? len : Math.min(len, maxReadLength);
        long bytesToSkip = bytesToRead == len ? 0L : len - bytesToRead;
        byte[] buf = new byte[(int)bytesToRead];
        this.readFully(buf);
        v.add(buf);
        if (bytesToSkip > 0L) {
            this.skipBytes(bytesToSkip);
            readState.setBytesSkipped(bytesToSkip);
        }
        return v;
    }

    private List readMultiByteArrayWithCharsetReplacement(long len, DicomCharset[] dicomCharsets, long maxReadLength, VR.ReadState readState) throws IOException {
        if (dicomCharsets.length == 1) {
            return this.readMultiByteArray(len, maxReadLength, readState);
        }
        byte[] buffer = new byte[(int)len];
        this.readFully(buffer);
        try {
            DicomCharsetCoder dicomCharsetCoder = new DicomCharsetCoder();
            return dicomCharsetCoder.splitMultivaluedText(buffer, dicomCharsets);
        }
        catch (Exception ex) {
            this.log.warn("Exception when reading multi-valued data element with replacement charsets.", ex);
            return this.splitMultiByteArray(buffer);
        }
    }

    private List readMultiByteArray(long len, long maxReadLength, VR.ReadState readState) throws IOException {
        long bytesToRead = maxReadLength <= 0L ? len : Math.min(len, maxReadLength);
        long bytesToSkip = bytesToRead == len ? 0L : len - bytesToRead;
        byte[] buf = new byte[(int)bytesToRead];
        this.readFully(buf);
        if (bytesToSkip > 0L) {
            this.skipBytes(bytesToSkip);
            readState.setBytesSkipped(bytesToSkip);
        }
        return this.splitMultiByteArray(buf);
    }

    private List splitMultiByteArray(byte[] buf) {
        byte[] buf2;
        ArrayList<byte[]> v = new ArrayList<byte[]>();
        int offset = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 92) continue;
            buf2 = new byte[i - offset];
            System.arraycopy(buf, offset, buf2, 0, buf2.length);
            v.add(buf2);
            offset = i + 1;
        }
        if (offset == 0) {
            v.add(buf);
        } else {
            buf2 = new byte[buf.length - offset];
            System.arraycopy(buf, offset, buf2, 0, buf2.length);
            v.add(buf2);
        }
        return v;
    }

    private List readSingleValue(int dcm_type, long len, long maxReadLength) throws IOException {
        long readBytes = maxReadLength <= 0L ? len : Math.min(len, maxReadLength);
        long skipBytes = readBytes == len ? 0L : len - readBytes;
        ByteArray byteArray = new ByteArray(readBytes);
        try {
            this.readFully(byteArray);
            if (skipBytes > 0L) {
                this.skipBytes(skipBytes);
            }
        }
        catch (EOFException ex) {
            if (Jdt.isReadIncompleteTag()) {
                this.log.warn("encountered EOFException while reading OB,OW or UN. Proceeding with partially read data");
            }
            throw ex;
        }
        if (this._bigEndian) {
            if (dcm_type == 24) {
                DicomUtils.swapWords(byteArray);
            } else if (dcm_type == 30) {
                DicomUtils.swapLongWords(byteArray);
            } else if (dcm_type == 34) {
                DicomUtils.swapVeryLongWords(byteArray);
            }
        }
        ArrayList<ByteArray> v = new ArrayList<ByteArray>();
        v.add(byteArray);
        return v;
    }

    private List readSingleOFValue(long len, long maxReadLength, VR.ReadState readState) throws IOException {
        int valueLength = DDictBase.getValueLength(29);
        int valuesToRead = (int)(maxReadLength == 0L ? len / (long)valueLength : Math.min(len / (long)valueLength, maxReadLength / (long)valueLength + 1L));
        int valuesToSkip = maxReadLength == 0L ? 0 : (int)(len / (long)valueLength - (long)valuesToRead);
        long bytesToSkip = (long)valuesToSkip * (long)valueLength;
        int remainder = (int)(len % 4L);
        float[] floatArray = new float[valuesToRead];
        for (int i = 0; i < valuesToRead; ++i) {
            floatArray[i] = Float.intBitsToFloat(this.readUInt32());
        }
        if (bytesToSkip > 0L) {
            this.skipBytes(bytesToSkip);
            readState.setBytesSkipped(bytesToSkip);
        }
        if (remainder > 0) {
            this.skipBytes(remainder);
        }
        ArrayList<float[]> v = new ArrayList<float[]>();
        v.add(floatArray);
        return v;
    }

    private List readSingleODValue(long len, long maxReadLength, VR.ReadState readState) throws IOException {
        int valueLength = DDictBase.getValueLength(31);
        int valuesToRead = (int)(maxReadLength == 0L ? len / (long)valueLength : Math.min(len / (long)valueLength, maxReadLength / (long)valueLength + 1L));
        int valuesToSkip = maxReadLength == 0L ? 0 : (int)(len / (long)valueLength - (long)valuesToRead);
        long bytesToSkip = (long)valuesToSkip * (long)valueLength;
        int remainder = (int)(len % 8L);
        double[] doubleArray = new double[valuesToRead];
        for (int i = 0; i < valuesToRead; ++i) {
            doubleArray[i] = Double.longBitsToDouble(this.readUInt64());
        }
        if (bytesToSkip > 0L) {
            this.skipBytes(bytesToSkip);
            readState.setBytesSkipped(bytesToSkip);
        }
        if (remainder > 0) {
            this.skipBytes(remainder);
        }
        ArrayList<double[]> v = new ArrayList<double[]>();
        v.add(doubleArray);
        return v;
    }

    List readVRValues(int dcm_type, long len, DicomCharset[] dicomCharsets, long maxReadLength, VR.ReadState readState) throws IOException {
        switch (dcm_type) {
            case 3: 
            case 21: 
            case 23: {
                return this.readFixed(dcm_type, len / 2L, maxReadLength, readState);
            }
            case 1: 
            case 5: 
            case 19: 
            case 26: {
                return this.readFixed(dcm_type, len / 4L, maxReadLength, readState);
            }
            case 20: 
            case 35: 
            case 36: {
                return this.readFixed(dcm_type, len / 8L, maxReadLength, readState);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                return this.readSingleValue(dcm_type, len, maxReadLength);
            }
            case 29: {
                return this.readSingleOFValue(len, maxReadLength, readState);
            }
            case 31: {
                return this.readSingleODValue(len, maxReadLength, readState);
            }
            case 13: 
            case 18: 
            case 27: 
            case 33: {
                return this.readSingleByteArray(len, maxReadLength, readState);
            }
            case 6: 
            case 7: 
            case 14: 
            case 32: {
                return this.readMultiByteArrayWithCharsetReplacement(len, dicomCharsets, maxReadLength, readState);
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                return this.readMultiByteArray(len, maxReadLength, readState);
            }
        }
        assert (false);
        throw new Error("unknown DICOM VR type constant: " + dcm_type);
    }

    List<ByteArray> readFragments(boolean skip, long maxReadLength, VR.ReadState readState) throws DicomException, IOException {
        ArrayList<ByteArray> fragments = new ArrayList<ByteArray>();
        ByteArray byteArray;
        while ((byteArray = this.readFragment(skip, maxReadLength, readState)) != null) {
            fragments.add(byteArray);
        }
        return fragments;
    }

    public long readFragmentHeader() throws IOException, DicomException {
        int group = this.readUInt16();
        int element = this.readUInt16();
        if (group == 65534 && element == 57565) {
            this.skipBytes(4L);
            return -1L;
        }
        if (group == 65534 && element == 57344) {
            long fragmentLength = this.readUInt32();
            return fragmentLength;
        }
        throw new DicomException(String.format("Unexpected tag encountered when reading onReaderEvent: %s", DumpUtils.tagString(group, element)));
    }

    public long peekFragmentHeader() throws IOException, DicomException {
        int group = this.readUInt16();
        int element = this.readUInt16();
        if (group == 65534 && element == 57565) {
            this.unreadUInt16(element);
            this.unreadUInt16(group);
            return -1L;
        }
        if (group == 65534 && element == 57344) {
            long fragmentLength = this.readUInt32();
            this.unreadUInt32((int)fragmentLength);
            this.unreadUInt16(element);
            this.unreadUInt16(group);
            return fragmentLength;
        }
        throw new DicomException(String.format("Unexpected tag encountered when reading onReaderEvent: %s", DumpUtils.tagString(group, element)));
    }

    public ByteArray readFragment(boolean skip, long maxReadLength, VR.ReadState readState) throws IOException, DicomException {
        int group = this.readUInt16();
        int element = this.readUInt16();
        if (group == 65534 && element == 57565) {
            this.skipBytes(4L);
            return null;
        }
        if (group == 65534 && element == 57344) {
            long fragmentLength = this.readUInt32();
            if (skip) {
                this.skipBytes(fragmentLength);
                return new ByteArray(0L);
            }
            long bytesToRead = maxReadLength <= 0L ? fragmentLength : Math.min(fragmentLength, maxReadLength);
            long bytesToSkip = bytesToRead == fragmentLength ? 0L : fragmentLength - bytesToRead;
            ByteArray byteArray = new ByteArray(bytesToRead);
            this.readFully(byteArray);
            if (bytesToSkip > 0L) {
                this.skipBytes(bytesToSkip);
                readState.setBytesSkipped(readState.getBytesSkipped() + bytesToSkip);
            }
            return byteArray;
        }
        throw new DicomException(String.format("Unexpected tag encountered when reading onReaderEvent: %s", DumpUtils.tagString(group, element)));
    }

    public int getCurrentTransferSyntax() {
        return super.getTransferSyntax();
    }
}

