/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.BulkDataReference;
import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DataElementValue;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.SingleVROutputStream;
import com.archimed.dicom.TransferSyntax;
import com.archimed.tool.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;

public class MultiVROutputStream
extends SingleVROutputStream {
    private static final int DELIMITER = 92;

    public MultiVROutputStream(OutputStream out) {
        super(out);
    }

    MultiVROutputStream(OutputStream out, long beginoff) {
        super(out, beginoff);
    }

    private int padChar(int dcm_type) {
        switch (dcm_type) {
            case 2: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                return 0;
            }
        }
        return 32;
    }

    public long writeFragment(ByteArray byteArray) throws IOException {
        this.writeInt16(65534);
        this.writeInt16(57344);
        this.writeInt32((int)byteArray.length());
        for (int i = 0; i < byteArray.arrays(); ++i) {
            this.write(byteArray.getArray(i));
        }
        return byteArray.length() + 8L;
    }

    public long writeFragment(byte[] fragment) throws IOException {
        return this.writeFragment(new ByteArray(new byte[][]{fragment}));
    }

    public long writeSequenceDelimitationItem() throws IOException {
        this.writeInt16(65534);
        this.writeInt16(57565);
        this.writeInt32(0);
        return 8L;
    }

    private int writeFixed(List val, int dcm_type) throws IOException {
        if (val.size() == 1 && val.get(0) instanceof BulkDataReference) {
            return (int)this.writeBulkDataReference((BulkDataReference)val.get(0), dcm_type);
        }
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            len += this.writeFixed(val.get(i), dcm_type);
        }
        return len;
    }

    private int writeSingleByteArray(List val, int dcm_type) throws IOException {
        byte[] ar = (byte[])val.get(0);
        this.write(ar);
        return ar.length;
    }

    private int writeMultiByteArray(List val, int dcm_type) throws IOException {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            if (i > 0) {
                this.write(92);
                ++len;
            }
            byte[] ar = (byte[])val.get(i);
            this.write(ar);
            len += ar.length;
        }
        return len;
    }

    private long writeSingleValue(List<DataElementValue> val, int dcm_type) throws IOException {
        DataElementValue dataElementValue = val.get(0);
        if (dataElementValue instanceof ByteArray) {
            return this.writeByteArray((ByteArray)dataElementValue, dcm_type);
        }
        if (dataElementValue instanceof BulkDataReference) {
            return this.writeBulkDataReference((BulkDataReference)dataElementValue, dcm_type);
        }
        throw new IllegalArgumentException("elements in list must be either ByteArray or BulkDataReference");
    }

    long writeByteArray(ByteArray byteArray, int dcm_type) throws IOException {
        if (this._bigEndian) {
            if (dcm_type == 24) {
                ByteArray temp = byteArray.copy();
                DicomUtils.swapWords(temp);
                this.write(temp);
                return temp.length();
            }
            if (dcm_type == 30) {
                ByteArray temp = byteArray.copy();
                DicomUtils.swapLongWords(temp);
                this.write(temp);
                return temp.length();
            }
            if (dcm_type == 34) {
                ByteArray temp = byteArray.copy();
                DicomUtils.swapVeryLongWords(temp);
                this.write(temp);
                return temp.length();
            }
            this.write(byteArray);
            return byteArray.length();
        }
        this.write(byteArray);
        return byteArray.length();
    }

    long writeBulkDataReference(BulkDataReference bulkDataReference, int dcm_type) throws IOException {
        ByteOrder transferSyntaxByteOrder;
        IOUtil.SWAP_MODE swapMode = IOUtil.SWAP_MODE.NONE;
        ByteOrder byteOrder = transferSyntaxByteOrder = TransferSyntax.isBigEndian(this.getTransferSyntax()) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        if (bulkDataReference.getByteOrder() != transferSyntaxByteOrder) {
            switch (DDictBase.getLengthForEndianness(dcm_type)) {
                case 2: {
                    swapMode = IOUtil.SWAP_MODE.WORD;
                    break;
                }
                case 4: {
                    swapMode = IOUtil.SWAP_MODE.LONGWORD;
                    break;
                }
                case 8: {
                    swapMode = IOUtil.SWAP_MODE.VERYLONGWORD;
                    break;
                }
                default: {
                    swapMode = IOUtil.SWAP_MODE.NONE;
                }
            }
        }
        return IOUtil.transferTo(bulkDataReference.getInputStream(), bulkDataReference.getOffset(), bulkDataReference.getLength(), this, swapMode);
    }

    int writeSingleOFValue(List val) throws IOException {
        if (val.get(0) instanceof float[]) {
            float[] temp = (float[])val.get(0);
            for (int i = 0; i < temp.length; ++i) {
                this.writeInt32(Float.floatToIntBits(temp[i]));
            }
            return temp.length * 4;
        }
        if (val.get(0) instanceof BulkDataReference) {
            return (int)this.writeBulkDataReference((BulkDataReference)val.get(0), 29);
        }
        throw new IllegalArgumentException("values of OF VR must be of type float[] or BulkDataReference");
    }

    int writeSingleODValue(List val) throws IOException {
        if (val.get(0) instanceof double[]) {
            double[] temp = (double[])val.get(0);
            for (int i = 0; i < temp.length; ++i) {
                this.writeInt64(Double.doubleToLongBits(temp[i]));
            }
            return temp.length * 8;
        }
        if (val.get(0) instanceof BulkDataReference) {
            return (int)this.writeBulkDataReference((BulkDataReference)val.get(0), 31);
        }
        throw new IllegalArgumentException("values of OF VR must be of type float[] or BulkDataReference");
    }

    int writeVRValues(List val, int dcm_type) throws IOException {
        int len = 0;
        switch (dcm_type) {
            case 1: 
            case 3: 
            case 5: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 35: 
            case 36: {
                return this.writeFixed(val, dcm_type);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: 
            case 30: 
            case 34: {
                len = (int)((long)len + this.writeSingleValue(val, dcm_type));
                break;
            }
            case 29: {
                len += this.writeSingleOFValue(val);
                break;
            }
            case 31: {
                len += this.writeSingleODValue(val);
                break;
            }
            case 13: 
            case 18: 
            case 27: 
            case 33: {
                len += this.writeSingleByteArray(val, dcm_type);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 32: {
                len += this.writeMultiByteArray(val, dcm_type);
                break;
            }
            default: {
                assert (false);
                throw new Error("unknown DICOM VR type constant: " + dcm_type);
            }
        }
        if (len % 2 == 1) {
            this.write(this.padChar(dcm_type));
            ++len;
        }
        return len;
    }
}

