/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class OffsetInputStream
extends PushbackInputStream {
    private long offset = 0L;
    private long temp;

    public OffsetInputStream(InputStream in) {
        this(in, 0);
    }

    public OffsetInputStream(InputStream in, int beginoff) {
        super(in, 256);
        this.offset = beginoff;
    }

    @Override
    public int read() throws IOException {
        ++this.offset;
        return super.read();
    }

    @Override
    public void unread(int b) throws IOException {
        --this.offset;
        super.unread(b);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b, 0, b.length);
    }

    @Override
    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.temp = super.read(b, off, len);
        this.offset += this.temp;
        return (int)this.temp;
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        super.unread(b, off, len);
        this.offset -= (long)len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.temp = super.skip(n);
        this.offset += this.temp;
        return this.temp;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void readFully(byte[] b) throws IOException {
        this.offset += (long)b.length;
        int count = 0;
        for (int n = 0; n < b.length; n += count) {
            count = super.read(b, n, b.length - n);
            if (count != -1) continue;
            throw new EOFException();
        }
    }

    public void readFully(ByteArray byteArray) throws IOException {
        for (int i = 0; i < byteArray.arrays(); ++i) {
            this.readFully(byteArray.getArray(i));
        }
    }

    public int skipBytes(long n) throws IOException {
        long bytesSkipped = 0L;
        while (bytesSkipped < n) {
            long skipped = this.skip(n - bytesSkipped);
            if (skipped == 0L) {
                int byteValue = super.read();
                if (byteValue == -1) {
                    throw new EOFException();
                }
                ++bytesSkipped;
                ++this.offset;
                continue;
            }
            bytesSkipped += skipped;
        }
        return (int)bytesSkipped;
    }

    public long getOffset() {
        return this.offset;
    }
}

