/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.charset.DicomCharsetCoder;
import com.archimed.dicom.charset.DicomCharsetException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Person {
    private static final int GROUPDELIM = 61;
    private static final int COMPDELIM = 94;
    public String familyName = "";
    public String givenName = "";
    public String middleName = "";
    public String prefix = "";
    public String suffix = "";
    public String familyNameIdeographic = "";
    public String givenNameIdeographic = "";
    public String middleNameIdeographic = "";
    public String prefixIdeographic = "";
    public String suffixIdeographic = "";
    public String familyNamePhonetic = "";
    public String givenNamePhonetic = "";
    public String middleNamePhonetic = "";
    public String prefixPhonetic = "";
    public String suffixPhonetic = "";
    private int startIndex;
    private int trailingCompDelims = 0;

    public Person() {
    }

    public Person(String str) {
        int beginGroup = 0;
        int endGroup = 0;
        endGroup = this.nextGroup_(beginGroup, str);
        this.trailingCompDelims = this.countTrailingCompDelims(str, endGroup);
        if (endGroup != 0) {
            this.familyName = this.extractComponent_(str, endGroup);
            this.givenName = this.extractComponent_(str, endGroup);
            this.middleName = this.extractComponent_(str, endGroup);
            this.prefix = this.extractComponent_(str, endGroup);
            this.suffix = this.extractComponent_(str, endGroup);
        }
        if (str.length() <= endGroup) {
            return;
        }
        this.startIndex = beginGroup = endGroup + 1;
        endGroup = this.nextGroup_(beginGroup, str);
        if (endGroup != 0) {
            this.familyNameIdeographic = this.extractComponent_(str, endGroup);
            this.givenNameIdeographic = this.extractComponent_(str, endGroup);
            this.middleNameIdeographic = this.extractComponent_(str, endGroup);
            this.prefixIdeographic = this.extractComponent_(str, endGroup);
            this.suffixIdeographic = this.extractComponent_(str, endGroup);
        }
        if (str.length() <= endGroup) {
            return;
        }
        this.startIndex = beginGroup = endGroup + 1;
        endGroup = this.nextGroup_(beginGroup, str);
        if (endGroup != 0) {
            this.familyNamePhonetic = this.extractComponent_(str, endGroup);
            this.givenNamePhonetic = this.extractComponent_(str, endGroup);
            this.middleNamePhonetic = this.extractComponent_(str, endGroup);
            this.prefixPhonetic = this.extractComponent_(str, endGroup);
            this.suffixPhonetic = this.extractComponent_(str, endGroup);
        }
    }

    public void clearTrailingComponentDelimiters() {
        this.trailingCompDelims = 0;
    }

    public String toString() {
        return this.toDICOMString();
    }

    public String singleByteComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyName);
        sb.append('^');
        sb.append(this.givenName);
        sb.append('^');
        sb.append(this.middleName);
        sb.append('^');
        sb.append(this.prefix);
        sb.append('^');
        sb.append(this.suffix);
        int c = 0;
        int i = sb.length() - 1;
        while (i >= 0 && sb.charAt(i) == '^') {
            --i;
            ++c;
        }
        for (i = 0; i < c - this.trailingCompDelims; ++i) {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() == 0) break;
        }
        return sb.toString();
    }

    public String ideographicComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyNameIdeographic);
        sb.append('^');
        sb.append(this.givenNameIdeographic);
        sb.append('^');
        sb.append(this.middleNameIdeographic);
        sb.append('^');
        sb.append(this.prefixIdeographic);
        sb.append('^');
        sb.append(this.suffixIdeographic);
        while (sb.charAt(sb.length() - 1) == '^') {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() != 0) continue;
            break;
        }
        return sb.toString();
    }

    public String phoneticComponentGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.familyNamePhonetic);
        sb.append('^');
        sb.append(this.givenNamePhonetic);
        sb.append('^');
        sb.append(this.middleNamePhonetic);
        sb.append('^');
        sb.append(this.prefixPhonetic);
        sb.append('^');
        sb.append(this.suffixPhonetic);
        while (sb.charAt(sb.length() - 1) == '^') {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() != 0) continue;
            break;
        }
        return sb.toString();
    }

    public String toDICOMString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.singleByteComponentGroup());
        sb.append('=');
        sb.append(this.ideographicComponentGroup());
        sb.append('=');
        sb.append(this.phoneticComponentGroup());
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() != 0) continue;
            break;
        }
        return sb.toString();
    }

    byte[] encode(DicomCharset singleByteCharset, DicomCharset ideographicCharset, DicomCharset phoneticCharset) throws DicomCharsetException {
        boolean switchToDefault = false;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            if (this.singleByteHasContent()) {
                byte[] singleByteGroup = this.encodeGroup(this.familyName, this.givenName, this.middleName, this.prefix, this.suffix, singleByteCharset, singleByteCharset, false);
                bout.write(singleByteGroup);
            }
            if (this.ideographicHasContent() || this.phoneticHasContent()) {
                this.writeDelimiter(bout, 61, singleByteCharset, singleByteCharset, false);
            }
            if (this.ideographicHasContent()) {
                byte[] ideographicGroup = this.encodeGroup(this.familyNameIdeographic, this.givenNameIdeographic, this.middleNameIdeographic, this.prefixIdeographic, this.suffixIdeographic, ideographicCharset, singleByteCharset, ideographicCharset != singleByteCharset);
                bout.write(ideographicGroup);
                boolean bl = switchToDefault = ideographicCharset == DicomCharset.ISO_2022_IR_87 || ideographicCharset == DicomCharset.ISO_2022_IR_159;
            }
            if (this.phoneticHasContent()) {
                this.writeDelimiter(bout, 61, ideographicCharset, singleByteCharset, switchToDefault);
                byte[] phoneticGroup = this.encodeGroup(this.familyNamePhonetic, this.givenNamePhonetic, this.middleNamePhonetic, this.prefixPhonetic, this.suffixPhonetic, phoneticCharset, singleByteCharset, phoneticCharset != singleByteCharset);
                bout.write(phoneticGroup);
                boolean bl = switchToDefault = phoneticCharset == DicomCharset.ISO_2022_IR_87 || phoneticCharset == DicomCharset.ISO_2022_IR_159;
            }
            if (switchToDefault) {
                bout.write(27);
                bout.write(singleByteCharset.getEscapeSequenceG0());
            }
            return bout.toByteArray();
        }
        catch (IOException ex) {
            throw new DicomCharsetException(ex.getMessage(), ex);
        }
    }

    private boolean singleByteHasContent() {
        return !this.familyName.equals("") || !this.givenName.equals("") || !this.middleName.equals("") || !this.prefix.equals("") || this.suffix.equals("");
    }

    private boolean ideographicHasContent() {
        return !this.familyNameIdeographic.equals("") || !this.givenNameIdeographic.equals("") || !this.middleNameIdeographic.equals("") || !this.prefixIdeographic.equals("") || !this.suffixIdeographic.equals("");
    }

    private boolean phoneticHasContent() {
        return !this.familyNamePhonetic.equals("") || !this.givenNamePhonetic.equals("") || !this.middleNamePhonetic.equals("") || !this.prefixPhonetic.equals("") || !this.suffixPhonetic.equals("");
    }

    private byte[] encodeGroup(String c1, String c2, String c3, String c4, String c5, DicomCharset activeCharset, DicomCharset delimiterCharset, boolean useEscapes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DicomCharsetCoder coder = Jdt.getCharsetCoder();
        this.writeComponent(bout, c1, activeCharset, useEscapes);
        if (!(c2.equals("") && c3.equals("") && c4.equals("") && c5.equals(""))) {
            this.writeDelimiter(bout, 94, activeCharset, delimiterCharset, useEscapes);
        }
        this.writeComponent(bout, c2, activeCharset, useEscapes);
        if (!(c3.equals("") && c4.equals("") && c5.equals(""))) {
            this.writeDelimiter(bout, 94, activeCharset, delimiterCharset, useEscapes);
        }
        this.writeComponent(bout, c3, activeCharset, useEscapes);
        if (!c4.equals("") || !c5.equals("")) {
            this.writeDelimiter(bout, 94, activeCharset, delimiterCharset, useEscapes);
        }
        this.writeComponent(bout, c4, activeCharset, useEscapes);
        if (!c5.equals("")) {
            this.writeDelimiter(bout, 94, activeCharset, delimiterCharset, useEscapes);
        }
        this.writeComponent(bout, c5, activeCharset, useEscapes);
        return bout.toByteArray();
    }

    private void writeComponent(ByteArrayOutputStream bout, String c, DicomCharset activeCharset, boolean useEscapes) throws IOException {
        if (c.equals("")) {
            return;
        }
        bout.write(Jdt.getCharsetCoder().encode(c, new DicomCharset[]{activeCharset}, useEscapes));
    }

    private void writeDelimiter(ByteArrayOutputStream bout, int delimiter, DicomCharset activeCharset, DicomCharset delimiterCharset, boolean useEscapes) throws IOException {
        if (useEscapes && activeCharset != DicomCharset.ISO_2022_IR_149) {
            bout.write(27);
            if (delimiterCharset.getEscapeSequenceG0() == null) {
                throw new DicomCharsetException("No escape sequence defined in charset to be used for encoding delimiters. Specified single-byte charset must be of IS0_2022 range.", null);
            }
            bout.write(delimiterCharset.getEscapeSequenceG0());
        }
        bout.write(delimiter);
    }

    private String extractComponent_(String str, int endIndex) {
        if (this.startIndex >= endIndex) {
            return "";
        }
        int index = this.nextComponent_(this.startIndex, endIndex - 1, str);
        if (index != 0) {
            String str2 = str.substring(this.startIndex, index);
            this.startIndex = index + 1;
            return str2;
        }
        this.startIndex = index + 1;
        return "";
    }

    private int nextGroup_(int index, String str) {
        for (int i = index; i < str.length(); ++i) {
            if (str.charAt(i) != '=') continue;
            return i;
        }
        return str.length();
    }

    private int nextComponent_(int startIndex, int endIndex, String str) {
        for (int i = startIndex; i <= endIndex; ++i) {
            if (str.charAt(i) != '^') continue;
            return i;
        }
        return endIndex + 1;
    }

    private int countTrailingCompDelims(String s, int endGroup) {
        int c = 0;
        int i = endGroup - 1;
        while (i >= 0 && s.charAt(i--) == '^') {
            ++c;
        }
        return c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (!this.familyName.equals(person.familyName)) {
            return false;
        }
        if (!this.familyNameIdeographic.equals(person.familyNameIdeographic)) {
            return false;
        }
        if (!this.familyNamePhonetic.equals(person.familyNamePhonetic)) {
            return false;
        }
        if (!this.givenName.equals(person.givenName)) {
            return false;
        }
        if (!this.givenNameIdeographic.equals(person.givenNameIdeographic)) {
            return false;
        }
        if (!this.givenNamePhonetic.equals(person.givenNamePhonetic)) {
            return false;
        }
        if (!this.middleName.equals(person.middleName)) {
            return false;
        }
        if (!this.middleNameIdeographic.equals(person.middleNameIdeographic)) {
            return false;
        }
        if (!this.middleNamePhonetic.equals(person.middleNamePhonetic)) {
            return false;
        }
        if (!this.prefix.equals(person.prefix)) {
            return false;
        }
        if (!this.prefixIdeographic.equals(person.prefixIdeographic)) {
            return false;
        }
        if (!this.prefixPhonetic.equals(person.prefixPhonetic)) {
            return false;
        }
        if (!this.suffix.equals(person.suffix)) {
            return false;
        }
        if (!this.suffixIdeographic.equals(person.suffixIdeographic)) {
            return false;
        }
        return this.suffixPhonetic.equals(person.suffixPhonetic);
    }

    public int hashCode() {
        int result = this.familyName.hashCode();
        result = 31 * result + this.givenName.hashCode();
        result = 31 * result + this.middleName.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.suffix.hashCode();
        result = 31 * result + this.familyNameIdeographic.hashCode();
        result = 31 * result + this.givenNameIdeographic.hashCode();
        result = 31 * result + this.middleNameIdeographic.hashCode();
        result = 31 * result + this.prefixIdeographic.hashCode();
        result = 31 * result + this.suffixIdeographic.hashCode();
        result = 31 * result + this.familyNamePhonetic.hashCode();
        result = 31 * result + this.givenNamePhonetic.hashCode();
        result = 31 * result + this.middleNamePhonetic.hashCode();
        result = 31 * result + this.prefixPhonetic.hashCode();
        result = 31 * result + this.suffixPhonetic.hashCode();
        return result;
    }
}

