/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.OffsetInputStream;
import com.archimed.dicom.TransferSyntax;
import java.io.IOException;
import java.io.InputStream;

class PrimitiveInputStream
extends OffsetInputStream {
    private int ts = 8193;
    private int temp = 0;
    private byte[] temp16 = new byte[2];
    private byte[] temp32 = new byte[4];
    private byte[] temp64 = new byte[8];
    protected boolean _bigEndian;

    PrimitiveInputStream(InputStream in) {
        super(in);
    }

    PrimitiveInputStream(InputStream in, int beginoff) {
        super(in, beginoff);
    }

    private int unsign(byte b) {
        return b & 0xFF;
    }

    long unsignToLong(int i) {
        return 0xFFFFFFFFL & (long)i;
    }

    void setTransferSyntax(int transyn) {
        this.ts = transyn;
        this._bigEndian = TransferSyntax.isBigEndian(transyn);
    }

    int getTransferSyntax() {
        return this.ts;
    }

    public int readUInt16() throws IOException {
        this.readFully(this.temp16);
        if (this._bigEndian) {
            return (this.unsign(this.temp16[0]) << 8) + this.unsign(this.temp16[1]);
        }
        return (this.unsign(this.temp16[1]) << 8) + this.unsign(this.temp16[0]);
    }

    void unreadUInt16(int val) throws IOException {
        if (this._bigEndian) {
            this.temp16[1] = (byte)val;
            this.temp16[0] = (byte)(val >>> 8);
        } else {
            this.temp16[0] = (byte)val;
            this.temp16[1] = (byte)(val >>> 8);
        }
        this.unread(this.temp16);
    }

    int readSInt16() throws IOException {
        this.readFully(this.temp16);
        if (this._bigEndian) {
            return (this.temp16[0] << 8) + this.unsign(this.temp16[1]);
        }
        return (this.temp16[1] << 8) + this.unsign(this.temp16[0]);
    }

    public int readUInt32() throws IOException {
        this.readFully(this.temp32);
        if (this._bigEndian) {
            this.temp = this.unsign(this.temp32[3]);
            this.temp += this.unsign(this.temp32[2]) << 8;
            this.temp += this.unsign(this.temp32[1]) << 16;
            this.temp += this.unsign(this.temp32[0]) << 24;
        } else {
            this.temp = this.unsign(this.temp32[0]);
            this.temp += this.unsign(this.temp32[1]) << 8;
            this.temp += this.unsign(this.temp32[2]) << 16;
            this.temp += this.unsign(this.temp32[3]) << 24;
        }
        return this.temp;
    }

    void unreadUInt32(int val) throws IOException {
        if (this._bigEndian) {
            this.temp32[0] = (byte)(val >>> 24);
            this.temp32[1] = (byte)(val >>> 16);
            this.temp32[2] = (byte)(val >>> 8);
            this.temp32[3] = (byte)val;
        } else {
            this.temp32[0] = (byte)val;
            this.temp32[1] = (byte)(val >>> 8);
            this.temp32[2] = (byte)(val >>> 16);
            this.temp32[3] = (byte)(val >>> 24);
        }
        this.unread(this.temp32);
    }

    int readSInt32() throws IOException {
        this.readFully(this.temp32);
        if (this._bigEndian) {
            this.temp = this.unsign(this.temp32[3]);
            this.temp += this.unsign(this.temp32[2]) << 8;
            this.temp += this.unsign(this.temp32[1]) << 16;
            this.temp += this.temp32[0] << 24;
        } else {
            this.temp = this.unsign(this.temp32[0]);
            this.temp += this.unsign(this.temp32[1]) << 8;
            this.temp += this.unsign(this.temp32[2]) << 16;
            this.temp += this.temp32[3] << 24;
        }
        return this.temp;
    }

    long readSInt64() throws IOException {
        this.readFully(this.temp64);
        long templ = this._bigEndian ? (long)this.unsign(this.temp64[7]) + ((long)this.unsign(this.temp64[6]) << 8) + ((long)this.unsign(this.temp64[5]) << 16) + ((long)this.unsign(this.temp64[4]) << 24) + ((long)this.unsign(this.temp64[3]) << 32) + ((long)this.unsign(this.temp64[2]) << 40) + ((long)this.unsign(this.temp64[1]) << 48) + ((long)this.unsign(this.temp64[0]) << 56) : (long)this.unsign(this.temp64[0]) + ((long)this.unsign(this.temp64[1]) << 8) + ((long)this.unsign(this.temp64[2]) << 16) + ((long)this.unsign(this.temp64[3]) << 24) + ((long)this.unsign(this.temp64[4]) << 32) + ((long)this.unsign(this.temp64[5]) << 40) + ((long)this.unsign(this.temp64[6]) << 48) + ((long)this.unsign(this.temp64[7]) << 56);
        return templ;
    }

    long readUInt64() throws IOException {
        this.readFully(this.temp64);
        long l = this._bigEndian ? (long)this.temp64[7] & 0xFFL | ((long)this.temp64[6] & 0xFFL) << 8 | ((long)this.temp64[5] & 0xFFL) << 16 | ((long)this.temp64[4] & 0xFFL) << 24 | ((long)this.temp64[3] & 0xFFL) << 32 | ((long)this.temp64[2] & 0xFFL) << 40 | ((long)this.temp64[1] & 0xFFL) << 48 | ((long)this.temp64[0] & 0xFFL) << 56 : (long)this.temp64[0] & 0xFFL | ((long)this.temp64[1] & 0xFFL) << 8 | ((long)this.temp64[2] & 0xFFL) << 16 | ((long)this.temp64[3] & 0xFFL) << 24 | ((long)this.temp64[4] & 0xFFL) << 32 | ((long)this.temp64[5] & 0xFFL) << 40 | ((long)this.temp64[6] & 0xFFL) << 48 | ((long)this.temp64[7] & 0xFFL) << 56;
        return l;
    }

    String readString(int len) throws IOException {
        byte[] s = new byte[len];
        this.readFully(s);
        return new String(s);
    }

    long readUInt32AsLong() throws IOException {
        return this.unsignToLong(this.readUInt32());
    }
}

