/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomObject;
import java.io.InputStream;
import java.util.EventObject;

public class TagReadEvent
extends EventObject {
    public static final int READ_TAG_DATA = 0;
    public static final int SKIP_TAG_DATA = 1;
    public static final int SKIP_TAG = 2;
    public static final int NEXT_TAG = 3;
    private InputStream in;
    private DataElement dataElement;
    private long offset;
    private int dataReadStatus = 0;
    private boolean stopReading = false;
    private long maxReadLength = 0L;
    private long bytesSkipped = 0L;

    TagReadEvent(DataElement dataElement, InputStream in, long offset) {
        super(dataElement.dcm);
        this.dataElement = dataElement;
        this.in = in;
        this.offset = offset;
    }

    public DicomObject getDicomObject() {
        return (DicomObject)this.getSource();
    }

    public int getGroup() {
        return this.dataElement.getGroup();
    }

    public int getElement() {
        return this.dataElement.getElement();
    }

    public int getTag() {
        return DDict.lookupDDict(this.getGroup(), this.getElement());
    }

    public int getVRType() {
        return this.dataElement.getVR();
    }

    public int getLength() {
        return (int)this.dataElement.dataLen;
    }

    public long getLengthAsLong() {
        return this.dataElement.dataLen;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public DataElement getDataElement() {
        return this.dataElement;
    }

    public int getDataReadStatus() {
        return this.dataReadStatus;
    }

    public void setDataReadStatus(int dataReadStatus) {
        if (dataReadStatus < 0 || dataReadStatus > 3) {
            throw new IllegalArgumentException("unknown dataReadStatus: " + dataReadStatus);
        }
        this.dataReadStatus = dataReadStatus;
    }

    public boolean isStopReading() {
        return this.stopReading;
    }

    public void setStopReading(boolean stopReading) {
        this.stopReading = stopReading;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getMaxReadLength() {
        return this.maxReadLength;
    }

    public void setMaxReadLength(long maxReadLength) {
        if (maxReadLength < 0L) {
            throw new IllegalArgumentException("maxReadLength must be non-negative");
        }
        this.maxReadLength = maxReadLength;
    }

    void setBytesSkipped(long bytesSkipped) {
        this.bytesSkipped = bytesSkipped;
    }

    public long getBytesSkipped() {
        return this.bytesSkipped;
    }
}

