/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class UID {
    public static final int UnknownUID = 0;
    public static final int DICOMApplicationContextName = 20481;
    public static final int DICOMControlledTerminology = 20482;
    static Map<Integer, UIDEntry> entries = new HashMap<Integer, UIDEntry>();

    public static UIDEntry getUIDEntry(int i) throws IllegalValueException {
        UIDEntry entry = entries.get(new Integer(i));
        if (entry == null) {
            throw new IllegalValueException("UID not found");
        }
        return entry;
    }

    public static UIDEntry getUIDEntry(String value) throws UnknownUIDException {
        Enumeration<UIDEntry> enum_ = Collections.enumeration(entries.values());
        while (enum_.hasMoreElements()) {
            UIDEntry entry = enum_.nextElement();
            if (!entry.getValue().equals(value)) continue;
            return entry;
        }
        throw new UnknownUIDException(value, "Unknown UID: '" + value + "'");
    }

    public static UIDEntry getUIDEntryForShortName(String shortName) throws UnknownUIDException {
        Enumeration<UIDEntry> enum_ = Collections.enumeration(entries.values());
        while (enum_.hasMoreElements()) {
            UIDEntry entry = enum_.nextElement();
            if (!entry.getShortName().equalsIgnoreCase(shortName)) continue;
            return entry;
        }
        throw new UnknownUIDException(shortName, "Unknown UID: '" + shortName + "'");
    }

    static {
        try {
            Class.forName("com.archimed.dicom.TransferSyntax");
            Class.forName("com.archimed.dicom.SOPClass");
            Class.forName("com.archimed.dicom.MetaSOPClass");
            Class.forName("com.archimed.dicom.SOPInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        entries.put(new Integer(20481), new UIDEntry(20481, "1.2.840.10008.3.1.1.1", "DICOM Application Context Name", "AC", 5));
        entries.put(new Integer(20482), new UIDEntry(20482, "1.2.840.10008.2.16.4", "DICOM Controlled Terminology", "CTER", 6));
    }
}

