/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.charset;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.log.JdtLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DicomCharsetCoder {
    public static final byte ESC = 27;
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char FF = '\f';
    public static final char TAB = '\t';
    public static final char CARET = '^';
    public static final char EQ = '=';
    public static final byte DELIMITER = 92;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomCharsetCoder.class);

    public byte[] encode(String str) throws DicomCharsetException {
        return this.encode(str, DicomCharset.DEFAULT);
    }

    public byte[] encode(String str, DicomCharset dicomCharset) {
        return this.encode(str, new DicomCharset[]{dicomCharset}, false);
    }

    public byte[] encode(String str, DicomCharset[] dicomCharsets) {
        return this.encode(str, dicomCharsets, false);
    }

    public byte[] encode(String str, DicomCharset dicomCharset, boolean escapeSequence) {
        return this.encode(str, new DicomCharset[]{dicomCharset}, escapeSequence);
    }

    private byte[] createArrayFromBuffer(ByteBuffer bb) {
        byte[] buffer = new byte[bb.position()];
        bb.rewind();
        bb.get(buffer);
        return buffer;
    }

    public byte[] encode(String str, DicomCharset[] dicomCharsets, boolean startWithEscape) {
        CharsetEncoder[] encoders = new CharsetEncoder[dicomCharsets.length];
        for (int i = 0; i < dicomCharsets.length; ++i) {
            encoders[i] = dicomCharsets[i].getJavaCharset().newEncoder();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(str.length() * 6 + 3);
        int activeEncoderIdx = 0;
        int previousEncoderIdx = 0;
        boolean b = false;
        block1: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (DicomCharsetCoder.isDicomControlCharacter(c)) {
                activeEncoderIdx = 0;
            }
            for (int j = 0; j < encoders.length; ++j) {
                b = false;
                if (!encoders[j].canEncode(c)) continue;
                if (startWithEscape && i == 0) {
                    byte[] escapeBuf = this.getEscapeSequence(dicomCharsets[j], c);
                    byteBuffer.put((byte)27);
                    byteBuffer.put(escapeBuf);
                }
                if (dicomCharsets.length == 1) {
                    CoderResult coderResult = encoders[j].encode(CharBuffer.wrap(str), byteBuffer, true);
                    if (!coderResult.isError()) break block1;
                    throw new DicomCharsetException(String.format("Unable to encode string with specified charsets (%s)", coderResult.toString()), null);
                }
                previousEncoderIdx = activeEncoderIdx;
                activeEncoderIdx = j;
                this.encodeCharacter(c, dicomCharsets[activeEncoderIdx], dicomCharsets[previousEncoderIdx], encoders[activeEncoderIdx], byteBuffer);
                b = true;
                break;
            }
            if (b) continue;
            throw new DicomCharsetException("Unable to encode string with specified charsets", null);
        }
        if (activeEncoderIdx > 0) {
            byteBuffer.put((byte)27);
            byteBuffer.put(dicomCharsets[0].getEscapeSequenceG0());
        }
        return this.createArrayFromBuffer(byteBuffer);
    }

    private static boolean isDicomControlCharacter(char c) {
        return c == '\n' || c == '\f' || c == '\r';
    }

    private static boolean switchToFirstCharset(byte b) {
        return b == 10 || b == 12 || b == 13 || b == 9;
    }

    private void encodeCharacter(char c, DicomCharset currentCharset, DicomCharset previousCharset, CharsetEncoder coder, ByteBuffer byteBuffer) {
        ByteBuffer tempBuffer;
        try {
            tempBuffer = coder.encode(CharBuffer.wrap(new char[]{c}));
            tempBuffer.rewind();
        }
        catch (CharacterCodingException ex) {
            throw new DicomCharsetException("Unable to encode character:" + ex, ex);
        }
        if (currentCharset != previousCharset) {
            tempBuffer.rewind();
            byteBuffer.put((byte)27);
            byteBuffer.put(this.getEscapeSequence(currentCharset, tempBuffer.get(0)));
        }
        byteBuffer.put(tempBuffer);
    }

    private byte[] getEscapeSequence(DicomCharset charset, char c) {
        return this.getEscapeSequence(charset, charset.getJavaCharset().encode(CharBuffer.wrap(new char[]{c})).get(0));
    }

    private byte[] getEscapeSequence(DicomCharset dicomCharset, byte encodedFirstByte) {
        byte[] escapeBuf;
        if (encodedFirstByte > 0) {
            escapeBuf = dicomCharset.getEscapeSequenceG0();
            if (escapeBuf == null) {
                throw new DicomCharsetException("no G0 escape sequence found for " + dicomCharset.getDefinedTerm());
            }
        } else {
            escapeBuf = dicomCharset.getEscapeSequenceG1();
            if (escapeBuf == null) {
                throw new DicomCharsetException("no G1 escape sequence found for " + dicomCharset.getDefinedTerm());
            }
        }
        return escapeBuf;
    }

    public String decode(byte[] ar) throws DicomCharsetException {
        return this.decode(ar, 0, ar.length);
    }

    public String decode(byte[] ar, int offset, int len) throws DicomCharsetException {
        return this.decode(ar, offset, len, new DicomCharset[]{DicomCharset.DEFAULT});
    }

    public String decode(byte[] ar, DicomCharset[] dicomCharsets) throws DicomCharsetException {
        return this.decode(ar, 0, ar.length, dicomCharsets);
    }

    public String decode(byte[] ar, int offset, int len, DicomCharset[] dicomCharsets) throws DicomCharsetException {
        if (dicomCharsets.length == 1) {
            return this.decodeWithoutCodeExtensions(ar, offset, len, dicomCharsets[0]);
        }
        try {
            return this.decodeWithCodeExtensions(ar, offset, len, dicomCharsets);
        }
        catch (CharacterCodingException ex) {
            throw new DicomCharsetException("unable to decode bytes into String", ex);
        }
    }

    private String decodeWithoutCodeExtensions(byte[] ar, int offset, int len, DicomCharset dicomCharset) throws DicomCharsetException {
        ByteBuffer bb = ByteBuffer.wrap(ar, offset, len);
        try {
            CharsetDecoder decoder = dicomCharset.getJavaCharset().newDecoder();
            return decoder.decode(bb).toString();
        }
        catch (CharacterCodingException | UnsupportedCharsetException ex) {
            this.log.warn("decoding using specified characterset failed,using fail-over: " + ex);
            this.log.debug("", ex);
            return this.decodeFailOver(ar, offset, len, ex);
        }
    }

    private String decodeWithCodeExtensions(byte[] ar, int offset, int len, DicomCharset[] dicomCharsets) throws DicomCharsetException, CharacterCodingException {
        CharsetDecoder currentG1CharsetDecoder;
        ByteBuffer bb = ByteBuffer.wrap(ar, offset, len);
        StringBuilder sb = new StringBuilder();
        byte[] esc2 = new byte[2];
        byte[] esc3 = new byte[3];
        byte[] characterBuffer = new byte[3];
        DicomCharset currentG0Charset = dicomCharsets[0];
        DicomCharset currentG1Charset = dicomCharsets[0] == DicomCharset.ISO_2022_IR_6 ? null : dicomCharsets[0];
        CharsetDecoder currentG0CharsetDecoder = currentG0Charset.getJavaCharset().newDecoder();
        CharsetDecoder charsetDecoder = currentG1CharsetDecoder = currentG1Charset == null ? null : currentG1Charset.getJavaCharset().newDecoder();
        while (bb.hasRemaining()) {
            bb.mark();
            byte b = bb.get();
            if (b == 27) {
                esc2[0] = bb.get();
                esc2[1] = bb.get();
                DicomCharset dc = DicomCharset.lookup(esc2);
                if (dc == null) {
                    esc3[0] = esc2[0];
                    esc3[1] = esc2[1];
                    esc3[2] = bb.get();
                    dc = DicomCharset.lookup(esc3);
                    if (dc == null) {
                        throw new DicomCharsetException("unknown escape sequence encountered", null);
                    }
                    if (Arrays.equals(esc3, dc.getEscapeSequenceG0())) {
                        currentG0Charset = dc;
                        currentG0CharsetDecoder = dc.getJavaCharset().newDecoder();
                        continue;
                    }
                    currentG1Charset = dc;
                    currentG1CharsetDecoder = dc.getJavaCharset().newDecoder();
                    continue;
                }
                if (Arrays.equals(esc2, dc.getEscapeSequenceG0())) {
                    currentG0Charset = dc;
                    currentG0CharsetDecoder = dc.getJavaCharset().newDecoder();
                    continue;
                }
                currentG1Charset = dc;
                currentG1CharsetDecoder = dc.getJavaCharset().newDecoder();
                continue;
            }
            if (DicomCharsetCoder.switchToFirstCharset(b)) {
                currentG0Charset = dicomCharsets[0];
                currentG1Charset = dicomCharsets[0] == DicomCharset.ISO_2022_IR_6 ? null : dicomCharsets[0];
                currentG0CharsetDecoder = currentG0Charset.getJavaCharset().newDecoder();
                currentG1CharsetDecoder = currentG1Charset == null ? null : currentG1Charset.getJavaCharset().newDecoder();
            }
            bb.reset();
            if (b >= 0) {
                bb.get(characterBuffer, 0, currentG0Charset.getCharLength());
                sb.append(currentG0CharsetDecoder.decode(ByteBuffer.wrap(characterBuffer, 0, currentG0Charset.getCharLength())));
                continue;
            }
            if (currentG1Charset != null) {
                bb.get(characterBuffer, 0, currentG1Charset.getCharLength());
                sb.append(currentG1CharsetDecoder.decode(ByteBuffer.wrap(characterBuffer, 0, currentG1Charset.getCharLength())));
                continue;
            }
            throw new DicomCharsetException("unable to read character in GR. No character set invoked in GR");
        }
        return sb.toString();
    }

    public List<byte[]> splitMultivaluedText(byte[] textBytes, DicomCharset[] dicomCharsets) throws DicomCharsetException, IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] esc2 = new byte[2];
        byte[] esc3 = new byte[3];
        DicomCharset currentG0Charset = dicomCharsets[0];
        DicomCharset currentG1Charset = dicomCharsets[0] == DicomCharset.ISO_2022_IR_6 ? null : dicomCharsets[0];
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        for (int i = 0; i < textBytes.length; ++i) {
            if (textBytes[i] == 27) {
                bout.write(textBytes[i]);
                esc2[0] = textBytes[++i];
                esc2[1] = textBytes[++i];
                DicomCharset dc = DicomCharset.lookup(esc2);
                if (dc == null) {
                    esc3[0] = esc2[0];
                    esc3[1] = esc2[1];
                    esc3[2] = textBytes[++i];
                    dc = DicomCharset.lookup(esc3);
                    if (dc == null) {
                        throw new DicomCharsetException("unknown escape sequence encountered", null);
                    }
                    if (Arrays.equals(esc3, dc.getEscapeSequenceG0())) {
                        currentG0Charset = dc;
                    } else {
                        currentG1Charset = dc;
                    }
                    bout.write(esc3);
                    continue;
                }
                if (Arrays.equals(esc2, dc.getEscapeSequenceG0())) {
                    currentG0Charset = dc;
                } else {
                    currentG1Charset = dc;
                }
                bout.write(esc2);
                continue;
            }
            if (textBytes[i] == 92) {
                list.add(bout.toByteArray());
                bout.reset();
                continue;
            }
            if (DicomCharsetCoder.switchToFirstCharset(textBytes[i])) {
                currentG0Charset = dicomCharsets[0];
                DicomCharset dicomCharset = currentG1Charset = dicomCharsets[0] == DicomCharset.ISO_2022_IR_6 ? null : dicomCharsets[0];
            }
            if (textBytes[i] >= 0) {
                bout.write(textBytes, i, currentG0Charset.getCharLength());
                i += currentG0Charset.getCharLength() - 1;
                continue;
            }
            if (currentG1Charset != null) {
                bout.write(textBytes, i, currentG1Charset.getCharLength());
                i += currentG1Charset.getCharLength() - 1;
                continue;
            }
            throw new DicomCharsetException("unable to read character in GR. No character set invoked in GR");
        }
        list.add(bout.toByteArray());
        return list;
    }

    private String decodeFailOver(byte[] ar, int offset, int len, Exception ex) {
        if (Jdt.isThrowCodingException()) {
            throw new DicomCharsetException("unable to decode bytes into String: " + ex, ex);
        }
        if (Jdt.isUsePlatformCharset()) {
            return new String(ar, offset, len);
        }
        CharsetDecoder decoder = DicomCharset.lookup("ISO_IR 100").getJavaCharset().newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        try {
            ByteBuffer bb = ByteBuffer.wrap(ar, offset, len);
            bb.position(offset);
            return decoder.decode(bb).toString();
        }
        catch (CharacterCodingException ex_) {
            throw new DicomCharsetException("unable to decode bytes into String with ISO_IR 100 charset: " + ex_, ex_);
        }
    }
}

