/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.iioplugin.image.GrayscaleIndex;
import com.archimed.dicom.iioplugin.image.RenderableImage;
import com.archimed.dicom.iioplugin.transform.GrayscaleTransformation;
import com.archimed.dicom.iioplugin.transform.GrayscaleTransformationFactory;
import com.archimed.dicom.iioplugin.transform.impl.OverlayTransformation;
import com.archimed.dicom.iioplugin.transform.impl.VoiLutWindowTransformation;
import com.archimed.log.JdtLogger;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class DicomBufferedImage
extends BufferedImage {
    private static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomBufferedImage.class);
    private RenderableImage renderableImage;
    private int minimumPixelValue;
    private int maximumPixelValue;

    DicomBufferedImage(RenderableImage renderableImage, ColorModel cm, WritableRaster raster) {
        super(cm, raster, true, null);
        this.renderableImage = renderableImage;
    }

    public BufferedImage createDefaultImage(boolean autoWindowLevel) {
        BufferedImage defaultImage = this;
        if (this.renderableImage.getGrayscaleIndex() != null) {
            GrayscaleIndex copyGrayscaleIndex = this.renderableImage.getGrayscaleIndex() == null ? null : this.renderableImage.getGrayscaleIndex().copy();
            GrayscaleTransformationFactory.applyTransformations((RenderableImage)this.renderableImage, (boolean)autoWindowLevel);
            defaultImage = this.renderTo8bitLut();
            this.renderableImage.setGrayscaleIndex(copyGrayscaleIndex);
        }
        this.applyOverlayTransformations(defaultImage.getRaster(), 255);
        return defaultImage;
    }

    public BufferedImage createImage(double windowCenter, double windowWidth) throws UnsupportedOperationException {
        if (this.renderableImage.getGrayscaleIndex() == null) {
            throw new UnsupportedOperationException("This method is only supported for grayscale images.");
        }
        GrayscaleIndex copyGrayscaleIndex = this.renderableImage.getGrayscaleIndex() == null ? null : this.renderableImage.getGrayscaleIndex().copy();
        GrayscaleTransformation originalTransformation = this.renderableImage.getVoiLutTransformation();
        VoiLutWindowTransformation transformation = new VoiLutWindowTransformation(windowCenter, windowWidth);
        this.renderableImage.setVoiLutTransformation((GrayscaleTransformation)transformation);
        GrayscaleTransformationFactory.applyTransformations((RenderableImage)this.renderableImage, (boolean)false);
        BufferedImage bit8BufferedImage = this.renderTo8bitLut();
        this.renderableImage.setGrayscaleIndex(copyGrayscaleIndex);
        this.renderableImage.setVoiLutTransformation(originalTransformation);
        this.applyOverlayTransformations(bit8BufferedImage.getRaster(), 255);
        return bit8BufferedImage;
    }

    public void applyOverlays(int overlayGrayscaleValue) {
        this.applyOverlayTransformations(this.getRaster(), overlayGrayscaleValue);
    }

    private BufferedImage renderTo8bitLut() {
        int[] grayscaleValues = this.renderableImage.getGrayscaleIndex().getGrayscaleValues();
        int size = grayscaleValues.length;
        GrayscaleIndex.PixelRange pixelRange = this.renderableImage.getGrayscaleIndex().getPixelRange();
        int level = this.getMinimumPixelValue() + this.renderableImage.getGrayscaleIndex().getOffset();
        double window = this.getMaximumPixelValue() - this.getMinimumPixelValue();
        byte[] lut = new byte[size];
        for (int i = 0; i < size; ++i) {
            lut[i] = (byte)Math.round((double)(grayscaleValues[i] - pixelRange.getMinimum()) * 255.0 / (double)pixelRange.getRange());
        }
        BufferedImage bufferedImage = this.perform8BitLookup(lut);
        return bufferedImage;
    }

    private BufferedImage perform8BitLookup(byte[] lut) {
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        WritableRaster writableRaster = cm.createCompatibleWritableRaster(this.getWidth(), this.getHeight());
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] data = dataBufferByte.getData();
        if (this.renderableImage.getDataBuffer().getDataType() == 1) {
            short[] sourceData = ((DataBufferUShort)this.renderableImage.getDataBuffer()).getData();
            for (int i = 0; i < data.length; ++i) {
                data[i] = lut[sourceData[i] & 0xFFFF];
            }
        } else if (this.renderableImage.getDataBuffer().getDataType() == 0) {
            byte[] sourceData = ((DataBufferByte)this.renderableImage.getDataBuffer()).getData();
            for (int i = 0; i < data.length; ++i) {
                data[i] = lut[sourceData[i] & 0xFF];
            }
        } else {
            throw new RuntimeException("Unsupported source databuffer type for performing 8bit rendering lookup");
        }
        return new BufferedImage(cm, writableRaster, false, new Hashtable());
    }

    public int getMaximumPixelValue() {
        return this.maximumPixelValue;
    }

    public void setMaximumPixelValue(int maximumPixelValue) {
        this.maximumPixelValue = maximumPixelValue;
    }

    public int getMinimumPixelValue() {
        return this.minimumPixelValue;
    }

    public void setMinimumPixelValue(int minimumPixelValue) {
        this.minimumPixelValue = minimumPixelValue;
    }

    private void applyOverlayTransformations(WritableRaster writableRaster, int overlayGrayscaleValue) {
        if (this.getColorModel() instanceof IndexColorModel && this.renderableImage.getOverlayTransformations().length > 0) {
            log.warn("Unable to apply overlays on IndexColorModel (paletteColorAsRGB ImageReadParam false ?)");
            return;
        }
        try {
            for (OverlayTransformation overlayTransformation : this.renderableImage.getOverlayTransformations()) {
                writableRaster = overlayTransformation.transform(writableRaster, overlayGrayscaleValue);
            }
        }
        catch (Throwable th) {
            log.warn("Exception while applying overlays", th);
        }
    }
}

