/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.iioplugin.DicomBufferedImage;
import com.archimed.dicom.iioplugin.DicomImageReadParam;
import com.archimed.dicom.iioplugin.image.GrayscaleIndex;
import com.archimed.dicom.iioplugin.image.RenderableImage;
import com.archimed.dicom.iioplugin.transform.impl.AutoWindowTransformation;
import com.archimed.log.JdtLogger;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class DicomBufferedImageFactory {
    private static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomBufferedImageFactory.class);

    public static BufferedImage createDicomBufferedImage(RenderableImage renderableImage, DicomImageReadParam dicomImageReadParam) {
        ColorModel usedColorModel;
        RenderableImage image = renderableImage;
        if (image.getGrayscaleIndex() != null) {
            int bitsStored = image.getGrayscaleIndex().getPixelDepth();
            int bitsAllocated = image.getGrayscaleIndex().getBits();
            int dataBufferType = bitsAllocated > 8 ? 1 : 0;
            usedColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bitsStored}, false, false, 1, dataBufferType);
        } else {
            usedColorModel = image.getColorModel();
        }
        DicomBufferedImage dicomBufferedImage = new DicomBufferedImage(image, usedColorModel, Raster.createWritableRaster(image.getSampleModel(), image.getDataBuffer(), new Point(0, 0)));
        if (renderableImage.getGrayscaleIndex() != null) {
            GrayscaleIndex gi = renderableImage.getGrayscaleIndex();
            if (renderableImage.getModalityLutTransformation() != null) {
                gi = gi.copy();
                gi = renderableImage.getModalityLutTransformation().transform(gi);
            }
            GrayscaleIndex.PixelRange realRange = AutoWindowTransformation.getRealPixelRange((DataBuffer)image.getDataBuffer(), (GrayscaleIndex)gi);
            dicomBufferedImage.setMaximumPixelValue(realRange.getMaximum());
            dicomBufferedImage.setMinimumPixelValue(realRange.getMinimum());
        }
        if (dicomImageReadParam.isPaletteColorAsRGB() && renderableImage.getColorModel() instanceof IndexColorModel) {
            log.info("converting palette color image to RGB");
            BufferedImage bufferedImage = DicomBufferedImageFactory.convertIndexedImageToRGB(dicomBufferedImage);
            dicomBufferedImage = new DicomBufferedImage(image, bufferedImage.getColorModel(), bufferedImage.getRaster());
        } else if (dicomImageReadParam.isYBRAsRGB() && renderableImage.getColorModel() != null && renderableImage.getColorModel().getColorSpace().getType() == 3) {
            log.info("converting YBR color image to RGB");
            BufferedImage bufferedImage = DicomBufferedImageFactory.converYBRToRGB(dicomBufferedImage);
            dicomBufferedImage = new DicomBufferedImage(image, bufferedImage.getColorModel(), bufferedImage.getRaster());
        }
        if (dicomImageReadParam.isCreateDicomBufferedImage()) {
            return dicomBufferedImage;
        }
        return dicomBufferedImage.createDefaultImage(dicomImageReadParam.isAutoWindowLevel());
    }

    private static BufferedImage convertIndexedImageToRGB(DicomBufferedImage dicomBufferedImage) {
        if (!(dicomBufferedImage.getColorModel() instanceof IndexColorModel)) {
            throw new IllegalArgumentException("unsupported colormodel for conversion to RGB");
        }
        int width = dicomBufferedImage.getSampleModel().getWidth();
        int height = dicomBufferedImage.getSampleModel().getHeight();
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
        WritableRaster targetRaster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
        int[] targetSamples = new int[3];
        WritableRaster sourceRaster = dicomBufferedImage.getRaster();
        int rY = sourceRaster.getMinY();
        int y = 0;
        while (y < height) {
            for (int x = 0; x < width; ++x) {
                int sourcePixel = dicomBufferedImage.getRGB(x, y);
                targetSamples[0] = (sourcePixel & 0xFF0000) >> 16;
                targetSamples[1] = (sourcePixel & 0xFF00) >> 8;
                targetSamples[2] = sourcePixel & 0xFF;
                targetRaster.setPixel(x, y, targetSamples);
            }
            ++y;
            ++rY;
        }
        return new BufferedImage(colorModel, targetRaster, false, null);
    }

    private static BufferedImage converYBRToRGB(DicomBufferedImage dicomBufferedImage) {
        int width = dicomBufferedImage.getSampleModel().getWidth();
        int height = dicomBufferedImage.getSampleModel().getHeight();
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
        WritableRaster targetRaster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
        int[] sourceSamples = new int[3];
        int[] targetSamples = new int[3];
        WritableRaster sourceRaster = dicomBufferedImage.getRaster();
        int rY = sourceRaster.getMinY();
        int y = 0;
        while (y < height) {
            for (int x = 0; x < width; ++x) {
                sourceSamples = sourceRaster.getPixel(x, y, sourceSamples);
                DicomBufferedImageFactory.convertYBRtoRGB(sourceSamples, targetSamples);
                targetRaster.setPixel(x, y, targetSamples);
            }
            ++y;
            ++rY;
        }
        return new BufferedImage(colorModel, targetRaster, false, null);
    }

    private static void convertYBRtoRGB(int[] s, int[] t) {
        t[0] = (int)Math.max(0.0, Math.min(255.0, (double)s[0] - 3.681999032610751E-5 * (double)(s[1] - 128) + 1.4019875769352639 * (double)(s[2] - 128)));
        t[1] = (int)Math.max(0.0, Math.min(255.0, (double)s[0] - 0.34411328131331737 * (double)(s[1] - 128) - 0.7141038211151132 * (double)(s[2] - 128)));
        t[2] = (int)Math.max(0.0, Math.min(255.0, (double)s[0] + 1.7719781167370596 * (double)(s[1] - 128) - 1.345834129159976E-4 * (double)(s[2] - 128)));
    }
}

