/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.image.DicomImageInfo;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class ColorModelFactory {
    public static ColorModel createCompatibleColorModel(DicomObject dcm) throws IllegalValueException {
        DicomImageInfo cmi = new DicomImageInfo(dcm);
        return ColorModelFactory.createColorModel(cmi);
    }

    public static ColorModel createColorModel(DicomImageInfo cmi) throws IllegalValueException {
        int pi = cmi.getPhotometricInterpretation();
        if (pi == 3) {
            return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        }
        if (pi == 1 || pi == 0) {
            int w;
            int c;
            if (cmi.getWindowCenters().length > 0) {
                c = (int)Math.round(Math.floor((cmi.getWindowCenters()[0] - cmi.getRescaleIntercept()) / cmi.getRescaleSlope()));
                w = (int)Math.round(Math.floor(cmi.getWindowWidths()[0] / cmi.getRescaleSlope()));
            } else {
                w = (1 << cmi.getBitsStored()) - 1;
                c = cmi.getPixelRepresentation() == 1 ? 0 : w / 2;
            }
            int center = c;
            if (cmi.getPixelRepresentation() == 1) {
                center += 1 << cmi.getBitsStored() - 1;
            }
            byte[] gray = ColorModelFactory.createLUT(cmi.getBitsStored(), w, center, pi == 0);
            return new IndexColorModel(cmi.getBitsStored(), 1 << cmi.getBitsStored(), gray, gray, gray);
        }
        if (pi == 2) {
            return new IndexColorModel(cmi.getBitsStored(), 1 << cmi.getBitsStored(), cmi.getPaletteRed(), cmi.getPaletteGreen(), cmi.getPaletteBlue());
        }
        return null;
    }

    public static byte[] createLUT(int bits, int window, int center, boolean inverse) {
        int i;
        byte[] gray = new byte[1 << bits];
        int t1 = Math.max(center - window / 2, 0);
        int t2 = Math.min(center + window / 2, gray.length);
        for (i = 0; i < t1; ++i) {
            gray[i] = !inverse ? 0 : -1;
        }
        while (i < t2) {
            gray[i] = !inverse ? (byte)((i - t1) * 255 / (t2 - t1)) : (byte)((t2 - i) * 255 / (t2 - t1));
            ++i;
        }
        while (i < gray.length) {
            gray[i] = !inverse ? -1 : 0;
            ++i;
        }
        return gray;
    }
}

