/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ULServiceMessage;

public class Abort
extends Response
implements ULServiceMessage {
    public static final int DICOM_UL_SERVICE_USER = 0;
    public static final int DICOM_UL_SERVICE_PROVIDER = 2;
    public static final int REASON_NOT_SPECIFIED = 0;
    public static final int UNRECOGNIZED_PDU = 1;
    public static final int UNEXPECTED_PDU = 2;
    public static final int UNRECOGNIZED_PDU_PARAMETER = 4;
    public static final int UNEXPECTED_PDU_PARAMETER = 5;
    public static final int INVALID_PDU_PARAMETER_VALUE = 6;
    private int source;
    private int reason;

    public Abort(int source, int reason) {
        this.source = source;
        this.reason = reason;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int getMessageType() {
        return 1007;
    }

    @Override
    public String getMessageTypeName() {
        return "A-ABORT";
    }

    public int getSource() {
        return this.source;
    }

    public String getSourceDescription() {
        switch (this.source) {
            case 0: {
                return "DICOM_UL_SERVICE_USER";
            }
            case 2: {
                return "DICOM_UL_SERVICE_PROVIDER";
            }
        }
        return "UNKNOWN";
    }

    public int getReason() {
        return this.reason;
    }

    public String getReasonDescription() {
        switch (this.reason) {
            case 0: {
                return "REASON_NOT_SPECIFIED";
            }
            case 1: {
                return "UNRECOGNIZED_PDU";
            }
            case 2: {
                return "UNEXPECTED_PDU";
            }
            case 4: {
                return "UNRECOGNIZED_PDU_PARAMETER";
            }
            case 5: {
                return "UNEXPECTED_PDU_PARAMETER";
            }
            case 6: {
                return "INVALID_PDU_PARAMETER_VALUE";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[abort, source: ");
        sb.append(this.getSourceDescription());
        sb.append(", reason: ");
        sb.append(this.getReasonDescription());
        sb.append("]");
        return sb.toString();
    }
}

