/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.AbortPdu;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduBuffer;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class AbortParser
implements PduParser {
    protected AbortParser() {
    }

    @Override
    public void format(Pdu pdu, PduBuffer pduBuffer) throws PduException {
        if (pdu.getType() != 7 || !(pdu instanceof Abort)) {
            throw new PduException("class " + this.getClass().getName() + " can only format Abort PDU");
        }
        try {
            Abort abo = (Abort)pdu;
            AbortPdu aboPdu = new AbortPdu(abo.getSource(), abo.getReason());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            aboPdu.write(bout);
            pduBuffer.setBytes(bout.toByteArray());
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }

    @Override
    public Pdu parse(PduBuffer pduBuffer) throws PduException {
        AbortPdu abortPdu = new AbortPdu();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(pduBuffer.getBytes(), 0, pduBuffer.getLength());
            abortPdu.read(bin);
            bin.close();
            return abortPdu.getAbort();
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }
}

