/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.Abort;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

class AbortPdu {
    private int pdutype = 7;
    private int length;
    private int source;
    private int reason;

    public AbortPdu() {
    }

    public AbortPdu(int source, int reason) {
        this.source = source;
        this.reason = reason;
    }

    public Abort getAbort() {
        Abort abort = new Abort(this.source, this.reason);
        return abort;
    }

    public void read(InputStream in) throws IOException, IllegalValueException {
        PushbackInputStream pbin = new PushbackInputStream(in);
        DataInputStream din = new DataInputStream(pbin);
        int b = din.read();
        if (b != this.pdutype) {
            throw new IllegalValueException("PDU-type field of Abort PDU not " + this.pdutype);
        }
        in.read();
        this.length = din.readInt();
        in.read();
        in.read();
        this.source = in.read();
        this.reason = in.read();
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        out.write(this.pdutype);
        out.write(0);
        dout.writeInt(4);
        out.write(0);
        out.write(0);
        out.write(this.source);
        out.write(this.reason);
    }
}

