/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class AbstractSyntaxItem {
    private byte itemtype = (byte)48;
    private UIDEntry abstractsyntax;

    public AbstractSyntaxItem(UIDEntry entry) {
        this.abstractsyntax = entry;
    }

    public AbstractSyntaxItem() {
    }

    public UIDEntry getAbstractSyntax() {
        return this.abstractsyntax;
    }

    public int getLength() {
        return this.abstractsyntax.getValue().length() + 4;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.abstractsyntax.getValue().length());
        out.write(this.abstractsyntax.getValue().getBytes());
    }

    public int read(DataInputStream in) throws IOException, IllegalValueException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("wrong itemtype of abstract syntax");
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        buf = StringTool.trimZeros(buf);
        String uid = new String(buf);
        try {
            this.abstractsyntax = UID.getUIDEntry(uid);
        }
        catch (UnknownUIDException e) {
            this.abstractsyntax = new UIDEntry(0, uid, "unknown uid", "??", 1);
        }
        return 4 + length;
    }
}

