/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.ApplicationContextItem;
import com.archimed.dicom.network.AsynchronousOperationsWindowSubItem;
import com.archimed.dicom.network.ExtendedNegotiation;
import com.archimed.dicom.network.ExtendedNegotiationSubItem;
import com.archimed.dicom.network.ImplementationClassUIDSubItem;
import com.archimed.dicom.network.ImplementationVersionNameSubItem;
import com.archimed.dicom.network.MaximumLengthSubItem;
import com.archimed.dicom.network.PresentationContextResponseItem;
import com.archimed.dicom.network.ScuScpRoleSubItem;
import com.archimed.dicom.network.SubItem;
import com.archimed.dicom.network.TransferSyntaxItem;
import com.archimed.dicom.network.UserIdentityNegotiationResponseSubItem;
import com.archimed.dicom.network.UserInfoItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;

class AssociateAcknowledgePdu {
    private int pdutype = 2;
    private int length;
    private int protocolversion;
    private String calledtitle;
    private String callingtitle;
    private ApplicationContextItem acitem;
    private UserInfoItem uiitem;
    private PresentationContextResponseItem pcritem;
    private List<PresentationContextResponseItem> pcritems;
    private Acknowledge ack;

    public AssociateAcknowledgePdu() {
        this.pcritems = new ArrayList<PresentationContextResponseItem>();
    }

    public AssociateAcknowledgePdu(Acknowledge ack) throws IllegalValueException {
        int i;
        this.calledtitle = ack.getCalledTitle();
        this.callingtitle = ack.getCallingTitle();
        this.acitem = new ApplicationContextItem();
        this.pcritems = new ArrayList<PresentationContextResponseItem>();
        for (int i2 = 0; i2 < ack.getPresentationContexts(); ++i2) {
            UIDEntry tsentry = ack.getTransferSyntax(i2);
            this.pcritem = tsentry == null ? new PresentationContextResponseItem(ack.getID(i2), ack.getResult(i2), null) : new PresentationContextResponseItem(ack.getID(i2), ack.getResult(i2), new TransferSyntaxItem(tsentry));
            this.pcritems.add(this.pcritem);
        }
        this.uiitem = new UserInfoItem(false);
        MaximumLengthSubItem mlitem = new MaximumLengthSubItem(ack.getMaxPduSize());
        ImplementationClassUIDSubItem icitem = new ImplementationClassUIDSubItem(ack.getImplementationClassUID());
        ImplementationVersionNameSubItem ivitem = new ImplementationVersionNameSubItem(ack.getImplementationVersionName());
        this.uiitem.addSubItem(mlitem);
        this.uiitem.addSubItem(icitem);
        this.uiitem.addSubItem(ivitem);
        for (int i3 = 0; i3 < ack.getRoles(); ++i3) {
            UIDEntry asentry = ack.getAbstractSyntaxForRole(i3);
            int scurole = ack.getScuRole(asentry.getConstant());
            int scprole = ack.getScpRole(asentry.getConstant());
            if (scurole == -1 || scprole == -1) continue;
            ScuScpRoleSubItem roleitem = new ScuScpRoleSubItem(asentry, scurole, scprole);
            this.uiitem.addSubItem(roleitem);
        }
        ExtendedNegotiation[] extendedNegotiations = ack.getExtendedNegotiations();
        if (extendedNegotiations != null) {
            for (i = 0; i < extendedNegotiations.length; ++i) {
                ExtendedNegotiationSubItem extnegitem = new ExtendedNegotiationSubItem(extendedNegotiations[i].getAbstractSyntax(), extendedNegotiations[i].getData());
                this.uiitem.addSubItem(extnegitem);
            }
        }
        if (ack.getMaxOperationsInvoked() != 1 || ack.getMaxOperationsPerformed() != 1) {
            AsynchronousOperationsWindowSubItem asyncitem = new AsynchronousOperationsWindowSubItem();
            asyncitem.setMaxNumberInvoked(ack.getMaxOperationsInvoked());
            asyncitem.setMaxNumberPerformed(ack.getMaxOperationsPerformed());
            this.uiitem.addSubItem(asyncitem);
        }
        if (ack.getUserIdentityNegotiationResponse() != null) {
            this.uiitem.addSubItem(new UserIdentityNegotiationResponseSubItem(ack.getUserIdentityNegotiationResponse()));
        }
        this.length = 68;
        this.length += this.acitem.getLength();
        for (i = 0; i < this.pcritems.size(); ++i) {
            this.length += this.pcritems.get(i).getLength();
        }
        this.length += this.uiitem.getLength();
    }

    public Acknowledge getAcknowledge() {
        return this.ack;
    }

    private void fillAcknowledge() throws IllegalValueException {
        this.ack = new Acknowledge();
        this.ack.setCalledTitle(this.calledtitle);
        this.ack.setCallingTitle(this.callingtitle);
        List<SubItem> subitems = this.uiitem.getSubItems();
        for (int i = 0; i < this.pcritems.size(); ++i) {
            PresentationContextResponseItem pcritem = this.pcritems.get(i);
            if (pcritem.getResult() == 0) {
                this.ack.addPresentationContext(pcritem.getID(), pcritem.getResult(), pcritem.getTransferSyntax().getConstant());
                continue;
            }
            this.ack.addPresentationContext(pcritem.getID(), pcritem.getResult(), 8193);
        }
        ArrayList<ExtendedNegotiation> exnegs = new ArrayList<ExtendedNegotiation>();
        for (int i = 0; i < subitems.size(); ++i) {
            SubItem subitem = subitems.get(i);
            if (subitem instanceof ImplementationClassUIDSubItem) {
                this.ack.setImplementationClassUID(((ImplementationClassUIDSubItem)subitem).getImplementationClassUID());
                continue;
            }
            if (subitem instanceof ImplementationVersionNameSubItem) {
                this.ack.setImplementationVersionName(((ImplementationVersionNameSubItem)subitem).getImplementationVersionName());
                continue;
            }
            if (subitem instanceof MaximumLengthSubItem) {
                this.ack.setMaxPduSize(((MaximumLengthSubItem)subitem).getMaxPduSize());
                continue;
            }
            if (subitem instanceof ScuScpRoleSubItem) {
                ScuScpRoleSubItem roleitem = (ScuScpRoleSubItem)subitem;
                this.ack.setScuScpRoleSelection(roleitem.getAbstractSyntax().getConstant(), roleitem.getScuRole(), roleitem.getScpRole());
                continue;
            }
            if (subitem instanceof AsynchronousOperationsWindowSubItem) {
                AsynchronousOperationsWindowSubItem asyncitem = (AsynchronousOperationsWindowSubItem)subitem;
                this.ack.setMaxOperationsInvoked(asyncitem.getMaxNumberInvoked());
                this.ack.setMaxOperationsPerformed(asyncitem.getMaxNumberPerformed());
                continue;
            }
            if (subitem instanceof ExtendedNegotiationSubItem) {
                ExtendedNegotiationSubItem enitem = (ExtendedNegotiationSubItem)subitem;
                ExtendedNegotiation en = new ExtendedNegotiation();
                en.setAbstractSyntax(enitem.getUIDEntry());
                en.setData(enitem.getApplicationInfo());
                exnegs.add(en);
                continue;
            }
            if (!(subitem instanceof UserIdentityNegotiationResponseSubItem)) continue;
            UserIdentityNegotiationResponseSubItem uinitem = (UserIdentityNegotiationResponseSubItem)subitem;
            this.ack.setUserIdentityNegotiationResponse(uinitem.getUserIdentityNegotiationResponse());
        }
        ExtendedNegotiation[] extendedNegotiations = new ExtendedNegotiation[exnegs.size()];
        for (int i = 0; i < exnegs.size(); ++i) {
            extendedNegotiations[i] = (ExtendedNegotiation)exnegs.get(i);
        }
        this.ack.setExtendedNegotiations(extendedNegotiations);
    }

    public int getLength() {
        return this.length + 6;
    }

    public List<PresentationContextResponseItem> getPresentationContextResponseItems() {
        return this.pcritems;
    }

    public void write(OutputStream out) throws IOException, IllegalValueException {
        int i;
        DataOutputStream dout = new DataOutputStream(out);
        out.write(this.pdutype);
        out.write(0);
        dout.writeInt(this.getLength() - 6);
        dout.writeChar(1);
        dout.writeChar(0);
        out.write(this.calledtitle.getBytes());
        for (i = 0; i < 16 - this.calledtitle.length(); ++i) {
            out.write(32);
        }
        out.write(this.callingtitle.getBytes());
        for (i = 0; i < 16 - this.callingtitle.length(); ++i) {
            out.write(32);
        }
        out.write(new byte[32]);
        this.acitem.write(dout);
        for (i = 0; i < this.pcritems.size(); ++i) {
            PresentationContextResponseItem pcritem = this.pcritems.get(i);
            pcritem.write(dout);
        }
        this.uiitem.write(dout);
    }

    public void read(InputStream in) throws IOException, IllegalValueException, UnknownUIDException {
        PushbackInputStream pbin = new PushbackInputStream(in);
        DataInputStream din = new DataInputStream(pbin);
        int b = din.read();
        if (b != this.pdutype) {
            throw new IllegalValueException("PDU-type field of Associate Acknowledge PDU not " + this.pdutype);
        }
        din.read();
        this.length = din.readInt();
        this.protocolversion = din.readChar();
        this.length -= 2;
        din.readFully(new byte[66]);
        this.length -= 66;
        ApplicationContextItem acitem = new ApplicationContextItem();
        this.length -= acitem.read(din);
        while (this.length > 0) {
            b = din.read();
            if (b == 33) {
                pbin.unread(33);
                this.pcritem = new PresentationContextResponseItem();
                this.length -= this.pcritem.read(din);
                this.pcritems.add(this.pcritem);
                continue;
            }
            if (b != 80) continue;
            pbin.unread(80);
            this.uiitem = new UserInfoItem(false);
            this.length -= this.uiitem.read(pbin);
        }
        this.fillAcknowledge();
    }
}

