/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.AssociateRequestPdu;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduBuffer;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import com.archimed.dicom.network.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class AssociateRequestParser
implements PduParser {
    protected AssociateRequestParser() {
    }

    @Override
    public void format(Pdu pdu, PduBuffer pduBuffer) throws PduException {
        if (pdu.getType() != 1 || !(pdu instanceof Request)) {
            throw new PduException("class " + this.getClass().getName() + " can only format Associate Requests");
        }
        try {
            AssociateRequestPdu reqPdu = new AssociateRequestPdu((Request)pdu);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(reqPdu.getLength());
            reqPdu.write(bout);
            pduBuffer.setBytes(bout.toByteArray());
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }

    @Override
    public Pdu parse(PduBuffer pduBuffer) throws PduException {
        AssociateRequestPdu reqPdu = new AssociateRequestPdu();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(pduBuffer.getBytes(), 0, pduBuffer.getLength());
            reqPdu.read(bin);
            bin.close();
            return reqPdu.getRequest();
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (UnknownUIDException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }
}

