/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.network.AssociationIOProgressListener;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class DimseWriter {
    private List progressListeners = new ArrayList();
    private boolean reportProgress = false;
    private OutputStream out;
    private Dimse dimse;
    private boolean writingCmd;
    private byte[] curbuf;
    private int curoffset;
    private int pdvstart;

    public DimseWriter(OutputStream out) {
        this.out = out;
    }

    void write(Dimse dimse, int maxpdusize, boolean sequndeflen, boolean separatedatapdv, int transfersyntax, boolean groupLengths) throws IOException, DicomException {
        this.dimse = dimse;
        if (this.curbuf == null || this.curbuf.length < maxpdusize) {
            this.curbuf = new byte[maxpdusize];
        }
        this.curoffset = 12;
        this.pdvstart = 6;
        Command command2 = dimse.getCommand();
        PDataTFOutputStream pdout = new PDataTFOutputStream();
        this.writingCmd = true;
        command2.write(pdout, false, 8193, sequndeflen);
        if (dimse.getDataSet() != null || dimse.isDeferredWriting()) {
            if (separatedatapdv) {
                this.flushPDataTF(true);
            } else {
                this.flushPDV(true);
            }
        }
        if (dimse.isDeferredWriting()) {
            this.writingCmd = false;
            dimse.setDataSetOutputStream(pdout);
        } else {
            if (dimse.getDataSet() != null) {
                DicomObject dataset = dimse.getDataSet();
                this.writingCmd = false;
                this.reportProgress = true;
                dataset.write(pdout, false, transfersyntax, sequndeflen, groupLengths);
            }
            pdout.close();
            this.reportProgress = false;
        }
    }

    private void flushPDV(boolean last) {
        int pdvlen = this.curoffset - this.pdvstart - 4;
        this.curbuf[this.pdvstart] = (byte)(pdvlen >> 24);
        this.curbuf[this.pdvstart + 1] = (byte)(pdvlen >> 16);
        this.curbuf[this.pdvstart + 2] = (byte)(pdvlen >> 8);
        this.curbuf[this.pdvstart + 3] = (byte)pdvlen;
        this.curbuf[this.pdvstart + 4] = (byte)this.dimse.getPresentationContextId();
        if (this.writingCmd) {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] | 1);
        } else {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] & 0xFFFFFFFE);
        }
        if (last) {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] | 2);
        } else {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] & 0xFFFFFFFD);
        }
        this.pdvstart += pdvlen + 4;
        this.curoffset += 6;
    }

    private void flushPDataTF(boolean last) throws IOException {
        int pdatalen = this.curoffset - 6;
        this.curbuf[0] = 4;
        this.curbuf[2] = (byte)(pdatalen >> 24);
        this.curbuf[3] = (byte)(pdatalen >> 16);
        this.curbuf[4] = (byte)(pdatalen >> 8);
        this.curbuf[5] = (byte)pdatalen;
        int pdvlen = this.curoffset - this.pdvstart - 4;
        this.curbuf[this.pdvstart] = (byte)(pdvlen >> 24);
        this.curbuf[this.pdvstart + 1] = (byte)(pdvlen >> 16);
        this.curbuf[this.pdvstart + 2] = (byte)(pdvlen >> 8);
        this.curbuf[this.pdvstart + 3] = (byte)pdvlen;
        this.curbuf[this.pdvstart + 4] = (byte)this.dimse.getPresentationContextId();
        if (this.writingCmd) {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] | 1);
        } else {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] & 0xFFFFFFFE);
        }
        if (last) {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] | 2);
        } else {
            int n = this.pdvstart + 5;
            this.curbuf[n] = (byte)(this.curbuf[n] & 0xFFFFFFFD);
        }
        this.out.write(this.curbuf, 0, this.curoffset);
        this.fireDataBytesSent(this.curoffset - 12);
        this.curoffset = 12;
        this.pdvstart = 6;
    }

    synchronized void addProgressListener(AssociationIOProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    synchronized void removeProgressListener(AssociationIOProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    synchronized void fireDataBytesSent(long numberOfBytes) {
        if (!this.reportProgress) {
            return;
        }
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ((AssociationIOProgressListener)it.next()).dataBytesSent(numberOfBytes);
        }
    }

    class PDataTFOutputStream
    extends OutputStream {
        private byte[] temp = new byte[1];

        PDataTFOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.temp[0] = (byte)b;
            this.write(this.temp, 0, 1);
        }

        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0 || offset + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            int n = len;
            while (n > 0) {
                int w = Math.min(n, DimseWriter.this.curbuf.length - DimseWriter.this.curoffset);
                System.arraycopy(b, offset, DimseWriter.this.curbuf, DimseWriter.this.curoffset, w);
                DimseWriter.this.curoffset = DimseWriter.this.curoffset + w;
                offset += w;
                if (w >= (n -= w)) continue;
                DimseWriter.this.flushPDataTF(false);
            }
        }

        @Override
        public void close() throws IOException {
            DimseWriter.this.flushPDataTF(true);
        }
    }
}

