/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.SubItem;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ImplementationClassUIDSubItem
extends SubItem {
    private int itemtype = 82;
    private String uid;

    public ImplementationClassUIDSubItem() {
    }

    public ImplementationClassUIDSubItem(String uid) {
        this.uid = uid;
    }

    @Override
    public int getLength() {
        return 4 + this.uid.length();
    }

    public String getImplementationClassUID() {
        return this.uid;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.uid.length());
        out.write(this.uid.getBytes());
    }

    @Override
    public int read(DataInputStream in) throws IOException, IllegalValueException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received Implementation Class UID Item  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        byte[] buf = new byte[length];
        in.readFully(buf);
        buf = StringTool.trimZeros(buf);
        this.uid = new String(buf);
        return 4 + length;
    }
}

