/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.PDataTF;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduBuffer;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import java.util.ArrayList;

class PDataTFParser
implements PduParser {
    protected PDataTFParser() {
    }

    @Override
    public void format(Pdu pdu, PduBuffer pduBuffer) throws PduException {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    public Pdu parse(PduBuffer pduBuffer) throws PduException {
        int offset;
        PDataTF.PDV pdv;
        byte[] buf = pduBuffer.getBytes();
        int n = pduBuffer.getLength();
        ArrayList<PDataTF.PDV> pdvList = new ArrayList<PDataTF.PDV>();
        for (offset = 6; offset < n; offset += pdv.length + 4) {
            pdv = new PDataTF.PDV();
            pdv.offset = offset;
            pdv.length = (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            pdv.pcid = buf[offset + 4] & 0xFF;
            pdv.command = (buf[offset + 5] & 1) != 0;
            pdv.last = (buf[offset + 5] & 2) != 0;
            pdvList.add(pdv);
        }
        if (offset != n) {
            throw new PduException("length of PDataTF pdu inconsistent with lengths of contained PDVs");
        }
        PDataTF pDataTF = new PDataTF(pdvList);
        return pDataTF;
    }
}

