/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PduOutputStream
extends FilterOutputStream {
    public static final byte COMMAND = 1;
    public static final byte DATA = 0;
    private int pdusize;
    private DataOutputStream dout;
    private byte[] buf;
    private int count;
    private byte type;
    private int pcnumber;

    public PduOutputStream(OutputStream out, int pdusize, int pcnumber, byte type) {
        super(out);
        this.dout = new DataOutputStream(out);
        if (pdusize == 0) {
            pdusize = 100000;
        } else {
            this.pdusize = pdusize;
        }
        this.type = type;
        this.pcnumber = pcnumber;
        this.buf = new byte[pdusize - 6];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        if (len <= this.buf.length - this.count) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        } else {
            System.arraycopy(b, off, this.buf, this.count, this.buf.length - this.count);
            off += this.buf.length - this.count;
            this.count += this.buf.length - this.count;
            this.flushBuffer();
            int blocks = (len -= this.buf.length - this.count) / this.buf.length;
            for (int i = 0; i < blocks; ++i) {
                System.arraycopy(b, off, this.buf, 0, this.buf.length);
                off += this.buf.length;
                len -= this.buf.length;
                this.count += this.buf.length;
                this.flushBuffer();
            }
            if (len > 0) {
                System.arraycopy(b, off, this.buf, 0, len);
                this.count += len;
            }
        }
    }

    private void flushBuffer() throws IOException {
        this.dout.writeByte(4);
        this.dout.writeByte(0);
        this.dout.writeInt(this.count + 6);
        this.dout.writeInt(this.count + 2);
        this.dout.writeByte(this.pcnumber);
        this.dout.writeByte(this.type);
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.count > 0) {
            this.dout.writeByte(4);
            this.dout.writeByte(0);
            this.dout.writeInt(this.count + 6);
            this.dout.writeInt(this.count + 2);
            this.dout.writeByte(this.pcnumber);
            this.dout.writeByte(this.type + 2);
            this.out.write(this.buf, 0, this.count);
        } else {
            this.dout.writeByte(4);
            this.dout.writeByte(0);
            this.dout.writeInt(6);
            this.dout.writeInt(2);
            this.dout.writeByte(this.pcnumber);
            this.dout.writeByte(this.type + 2);
        }
    }
}

