/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.network.AbortParser;
import com.archimed.dicom.network.AssociateAcknowledgeParser;
import com.archimed.dicom.network.AssociateRejectParser;
import com.archimed.dicom.network.AssociateRequestParser;
import com.archimed.dicom.network.PDataTFParser;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import com.archimed.dicom.network.ReleaseRequestParser;
import com.archimed.dicom.network.ReleaseResponseParser;

class PduParserFactory {
    private static final AssociateRequestParser associateRequestParser = new AssociateRequestParser();
    private static final AssociateAcknowledgeParser associateAcknowledgeParser = new AssociateAcknowledgeParser();
    private static final AssociateRejectParser associateRejectParser = new AssociateRejectParser();
    private static final AbortParser abortParser = new AbortParser();
    private static final PDataTFParser pDataTFParser = new PDataTFParser();
    private static final ReleaseRequestParser releaseRequestParser = new ReleaseRequestParser();
    private static final ReleaseResponseParser releaseResponseParser = new ReleaseResponseParser();

    PduParserFactory() {
    }

    public static final PduParser createParser(int pduType) throws PduException {
        switch (pduType) {
            case 1: {
                return associateRequestParser;
            }
            case 2: {
                return associateAcknowledgeParser;
            }
            case 3: {
                return associateRejectParser;
            }
            case 7: {
                return abortParser;
            }
            case 4: {
                return pDataTFParser;
            }
            case 5: {
                return releaseRequestParser;
            }
            case 6: {
                return releaseResponseParser;
            }
        }
        throw new PduException("Unknown pdu type: " + pduType);
    }
}

