/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.AbstractSyntaxItem;
import com.archimed.dicom.network.TransferSyntaxItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class PresentationContextItem {
    private byte itemtype = (byte)32;
    private int id;
    private List<TransferSyntaxItem> traitems;
    private AbstractSyntaxItem absitem;

    public PresentationContextItem() {
    }

    public PresentationContextItem(int id, AbstractSyntaxItem absitem, List<TransferSyntaxItem> traitems) {
        this.id = id;
        this.absitem = absitem;
        this.traitems = traitems;
    }

    public int getID() {
        return this.id;
    }

    public int getLength() {
        return 4 + this.itemlengthPresCxtItem();
    }

    public AbstractSyntaxItem getAbstractSyntaxItem() {
        return this.absitem;
    }

    public List<TransferSyntaxItem> getTransferSyntaxes() {
        return this.traitems;
    }

    public void addTransferSyntaxItem(TransferSyntaxItem traitem) {
        this.traitems.add(traitem);
    }

    private int itemlengthPresCxtItem() {
        int length = 4;
        length += this.absitem.getLength();
        for (int j = 0; j < this.traitems.size(); ++j) {
            TransferSyntaxItem traitem = this.traitems.get(j);
            length += traitem.getLength();
        }
        return length;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.itemlengthPresCxtItem());
        out.write(this.id);
        out.write(0);
        out.write(0);
        out.write(0);
        this.absitem.write(out);
        for (int i = 0; i < this.traitems.size(); ++i) {
            this.traitems.get(i).write(out);
        }
    }

    int read(DataInputStream din) throws IOException, IllegalValueException {
        int length;
        int b = din.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("wrong item type of presentation context item");
        }
        din.read();
        int length2 = length = din.readChar();
        this.id = din.read();
        din.read();
        din.read();
        din.read();
        length -= 4;
        this.absitem = new AbstractSyntaxItem();
        int r = this.absitem.read(din);
        length -= r;
        this.traitems = new ArrayList<TransferSyntaxItem>();
        while (length > 0) {
            TransferSyntaxItem traitem = new TransferSyntaxItem();
            r = traitem.read(din);
            this.traitems.add(traitem);
            length -= r;
        }
        return length2 + 4;
    }
}

