/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.SubItem;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ScuScpRoleSubItem
extends SubItem {
    private int itemtype = 84;
    private int scurole;
    private int scprole;
    private UIDEntry asentry;

    public ScuScpRoleSubItem() {
    }

    public ScuScpRoleSubItem(UIDEntry asentry, int scurole, int scprole) {
        this.asentry = asentry;
        this.scurole = scurole;
        this.scprole = scprole;
    }

    @Override
    public int getLength() {
        int length = 8;
        if (this.asentry != null) {
            length += this.asentry.getValue().length();
        }
        return length;
    }

    public UIDEntry getAbstractSyntax() {
        return this.asentry;
    }

    public int getScuRole() {
        return this.scurole;
    }

    public int getScpRole() {
        return this.scprole;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(this.asentry.getValue().length() + 4);
        out.writeChar(this.asentry.getValue().length());
        out.write(this.asentry.getValue().getBytes());
        out.write(this.scurole);
        out.write(this.scprole);
    }

    @Override
    public int read(DataInputStream in) throws IOException, IllegalValueException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received ScuScpRoleSubItem  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        char length2 = in.readChar();
        byte[] buf = new byte[length2];
        in.readFully(buf);
        buf = StringTool.trimZeros(buf);
        String uid = new String(buf);
        try {
            this.asentry = UID.getUIDEntry(uid);
        }
        catch (UnknownUIDException e) {
            this.asentry = new UIDEntry(0, uid, "unknown uid", "??", 1);
        }
        this.scurole = in.read();
        this.scprole = in.read();
        return 6 + length2 + 2;
    }
}

