/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CEchoSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.impl.BasicCEchoSCU;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.net.Socket;

public class CEchoSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CEchoSCUFactory.class);

    private CEchoSCUFactory() {
    }

    public static CEchoSCU createCEchoSCU(String host, int port, String calledAETitle, String localAETitle) {
        return new BasicCEchoSCU(host, port, calledAETitle, localAETitle);
    }

    public static void executeCEcho(String host, int port, String calledAE, String callingAE) throws SCUException, DicomException, IOException {
        CEchoSCUFactory.executeCEcho(host, port, calledAE, callingAE, 0);
    }

    public static void executeCEcho(String host, int port, String calledAE, String callingAE, int timeout) throws SCUException, DicomException, IOException {
        Socket socket = new Socket(host, port);
        socket.setSoTimeout(timeout);
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(calledAE);
        request.setCallingTitle(callingAE);
        try {
            request.addPresentationContext(1, 4097, new int[]{8193});
        }
        catch (IllegalValueException ex) {
            log.error("IllegalValueException while adding presentation context: " + ex, ex);
            throw new SCUException("IllegalValueException while adding presentation context: " + ex, ex);
        }
        request.setMaxPduSize(32768);
        log.debug(request);
        try {
            associationIO.write(request);
        }
        catch (DicomException ex) {
            log.error("DicomException while writing Association Request: " + ex, ex);
            throw new SCUException("DicomException while writing Association Request: " + ex, ex);
        }
        ULServiceMessage ulServiceMessage = null;
        try {
            ulServiceMessage = associationIO.read();
        }
        catch (DicomException ex) {
            log.error("DicomException while reading Association Response: " + ex, ex);
            throw new SCUException("DicomException while writing Association Response: " + ex, ex);
        }
        log.debug(ulServiceMessage);
        switch (ulServiceMessage.getMessageType()) {
            case 1002: {
                int result;
                Acknowledge acknowledge = (Acknowledge)ulServiceMessage;
                try {
                    result = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, 4097);
                }
                catch (IllegalValueException ex) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + ex, ex);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + ex);
                }
                if (result == 0) {
                    Command cechoreqcmd = Command.createCEchoReq(1, 4097);
                    Dimse cechoreq = new Dimse(1, cechoreqcmd, null);
                    associationIO.write(cechoreq);
                    ulServiceMessage = associationIO.read();
                    Command cechorescmd = null;
                    if (!(ulServiceMessage instanceof Dimse)) {
                        log.error("unexpected pdu received: " + ulServiceMessage);
                        throw new SCUException("unexpected pdu received: " + ulServiceMessage);
                    }
                    cechorescmd = ((Dimse)ulServiceMessage).getCommand();
                    if (cechorescmd.getStatus() != 0) {
                        String s = "non-success status received in C-ECHO resposnse: " + cechorescmd.getStatus();
                        log.error(s);
                        throw new SCUException(s);
                    }
                    CEchoSCUFactory.release(associationIO);
                    break;
                }
                throw new SCUException("association acknowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + ulServiceMessage);
                throw new SCUException("association reject received: " + ulServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + ulServiceMessage);
                throw new SCUException("abort received: " + ulServiceMessage);
            }
            default: {
                log.error("unexpected pdu received: " + ulServiceMessage);
                throw new SCUException("unexpected pdu received: " + ulServiceMessage);
            }
        }
    }
}

