/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.TransferSyntaxUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CStoreItemRequest;
import com.archimed.dicom.scu.CStoreSCU;
import com.archimed.dicom.scu.DatasetCStoreItemRequest;
import com.archimed.dicom.scu.DeferredCStoreItemRequest;
import com.archimed.dicom.scu.FileCStoreItemRequest;
import com.archimed.dicom.scu.MultiCStoreSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.StreamedFileCStoreItemRequest;
import com.archimed.dicom.scu.impl.BasicMultiCStoreSCU;
import com.archimed.dicom.scu.impl.DeferredMultiCStoreSCU;
import com.archimed.log.JdtLogger;
import com.archimed.util.tuple.ImmutablePair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CStoreSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CStoreSCUFactory.class);

    public static Command executeCStore(String host, int port, String callingAE, String calledAE, String file) throws SCUException, DicomException, IOException {
        TransferSyntaxUID transferSyntaxUID;
        DicomObject meta;
        FileInputStream fin = new FileInputStream(file);
        DicomReader dcmReader = new DicomReader();
        DicomObject dataset = dcmReader.read((InputStream)fin, true);
        fin.close();
        if (log.isDebugEnabled()) {
            DumpUtils dmpUtils = new DumpUtils(true, false);
            StringBuffer sb = new StringBuffer();
            dmpUtils.dump(dataset, sb);
            log.debug("DUMP DICOMFILE:");
            log.debug("\r\n" + sb.toString());
        }
        if ((meta = dataset.getFileMetaInformation()) == null) {
            throw new SCUException("No file meta information");
        }
        String s = meta.getString(131088, 0);
        if (s == null) {
            throw new SCUException("No specified transfer syntax in file meta information");
        }
        try {
            transferSyntaxUID = (TransferSyntaxUID)UID.getUIDEntry(s);
        }
        catch (UnknownUIDException ex) {
            throw new SCUException("Unknown transfer syntax in file meta information: '" + s + "'");
        }
        return CStoreSCUFactory.executeCStore(host, port, callingAE, calledAE, dataset, transferSyntaxUID);
    }

    public static Command executeCStore(String host, int port, String callingAE, String calledAE, DicomObject dataset, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        try {
            SOPClassUID sopClassUID;
            String sopClass = dataset.getString(524310, 0);
            try {
                sopClassUID = (SOPClassUID)UID.getUIDEntry(sopClass);
            }
            catch (UnknownUIDException ex) {
                log.error("UnknownUIDException while executing C-STORE", ex);
                throw new SCUException("UnknownUIDException while executing C-STORE: + ex", ex);
            }
            CStoreSCU cStoreSCU = CStoreSCUFactory.createCStoreSCU(host, port, callingAE, calledAE, sopClassUID, transferSyntaxUID);
            Command cmd = cStoreSCU.cstore(dataset, 0);
            CStoreSCUFactory.release(cStoreSCU.getAssociationIO());
            return cmd;
        }
        catch (DicomException ex) {
            log.error("DicomException while executing C-STORE: " + ex, ex);
            throw new SCUException("DicomException while executing C-STORE: + ex", ex);
        }
    }

    public static CStoreSCU createCStoreSCU(String host, int port, String callingAE, String calledAE, SOPClassUID sopClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        Socket socket = new Socket(host, port);
        return CStoreSCUFactory.createCStoreSCU(socket, callingAE, calledAE, sopClassUID, transferSyntaxUID);
    }

    public static CStoreSCU createCStoreSCU(Socket socket, String callingAE, String calledAE, SOPClassUID sopClassUID, TransferSyntaxUID transferSyntaxUID) throws SCUException, IOException {
        ULServiceMessage ulServiceMessage;
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(calledAE);
        request.setCallingTitle(callingAE);
        try {
            request.addPresentationContext(1, sopClassUID.getConstant(), new int[]{transferSyntaxUID.getConstant()});
        }
        catch (IllegalValueException ex) {
            log.error("IllegalValueException while adding presentation context: " + ex, ex);
            throw new SCUException("IllegalValueException while adding presentation context: " + ex, ex);
        }
        request.setMaxPduSize(32768);
        log.debug(request);
        try {
            associationIO.write(request);
        }
        catch (DicomException ex) {
            log.error("DicomException while writing Association Request: " + ex, ex);
            throw new SCUException("DicomException while writing Association Request: " + ex, ex);
        }
        try {
            ulServiceMessage = associationIO.read();
        }
        catch (DicomException ex) {
            log.error("DicomException while reading Association Response: " + ex, ex);
            throw new SCUException("DicomException while writing Association Response: " + ex, ex);
        }
        log.debug(ulServiceMessage);
        switch (ulServiceMessage.getMessageType()) {
            case 1002: {
                int result;
                Acknowledge acknowledge = (Acknowledge)ulServiceMessage;
                try {
                    result = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, sopClassUID.getConstant());
                }
                catch (IllegalValueException ex) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + ex, ex);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + ex);
                }
                if (result == 0) {
                    return new CStoreSCU(associationIO, 1, sopClassUID);
                }
                throw new SCUException("association acknowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + ulServiceMessage);
                throw new SCUException("association reject received: " + ulServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + ulServiceMessage);
                throw new SCUException("abort received: " + ulServiceMessage);
            }
        }
        log.error("unexpected pdu received: " + ulServiceMessage);
        throw new SCUException("unexpected pdu received: " + ulServiceMessage);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, File file, boolean recurse) {
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, new File[]{file}, recurse);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, File[] files, boolean recurse) {
        List<File> fileList = new ArrayList<File>();
        for (File file : files) {
            fileList = CStoreSCUFactory.getInputFiles(fileList, file, recurse);
        }
        CStoreItemRequest[] itemRequests = new CStoreItemRequest[fileList.size()];
        for (int i = 0; i < fileList.size(); ++i) {
            itemRequests[i] = new FileCStoreItemRequest(fileList.get(i));
        }
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, DicomObject dataset) {
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, new DicomObject[]{dataset});
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, DicomObject[] datasets) {
        CStoreItemRequest[] itemRequests = new CStoreItemRequest[datasets.length];
        for (int i = 0; i < datasets.length; ++i) {
            itemRequests[i] = new DatasetCStoreItemRequest(datasets[i]);
        }
        return CStoreSCUFactory.createMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, final Iterator<InputStream> dicomStreamIterator, ImmutablePair<SOPClassUID, TransferSyntaxUID>[] proposedPresentationContexts) {
        Iterator<DeferredCStoreItemRequest> itemRequestIterator = new Iterator<DeferredCStoreItemRequest>(){

            @Override
            public boolean hasNext() {
                return dicomStreamIterator.hasNext();
            }

            @Override
            public DeferredCStoreItemRequest next() {
                return new StreamedFileCStoreItemRequest((InputStream)dicomStreamIterator.next());
            }

            @Override
            public void remove() {
                dicomStreamIterator.remove();
            }
        };
        return new DeferredMultiCStoreSCU(host, port, calledAETitle, localAETitle, (Iterator)itemRequestIterator, proposedPresentationContexts);
    }

    public static MultiCStoreSCU createMultiCStoreSCU(String host, int port, String calledAETitle, String localAETitle, CStoreItemRequest[] itemRequests) {
        return new BasicMultiCStoreSCU(host, port, calledAETitle, localAETitle, itemRequests);
    }

    private static List<File> getInputFiles(List<File> list, File inputFile, boolean recurse) {
        if (inputFile.isFile()) {
            list.add(inputFile);
        } else if (recurse) {
            File[] children = inputFile.listFiles();
            if (children == null) {
                return list;
            }
            Arrays.sort(children, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isFile() && f2.isDirectory()) {
                        return -1;
                    }
                    if (f1.isDirectory() && f2.isFile()) {
                        return 1;
                    }
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }
            });
            for (File child : children) {
                CStoreSCUFactory.getInputFiles(list, child, true);
            }
        }
        return list;
    }
}

