/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

public class SCUProgressEvent {
    public static final int OPEN_SOCKET = 1;
    public static final int ASSOCIATE_REQUEST = 2;
    public static final int ASSOCIATE_RESPONSE = 3;
    public static final int ASSOCIATE_RELEASE_REQUEST = 6;
    public static final int ASSOCIATE_RELEASE_RESPONSE = 7;
    public static final int CLOSE_SOCKET = 8;
    public static final int C_ECHO_REQUEST = 4;
    public static final int C_ECHO_REQUEST_SEND = 4;
    public static final int C_ECHO_RESPONSE = 5;
    public static final int C_ECHO_RESPONSE_RECEIVE = 5;
    public static final int C_STORE_REQUEST = 9;
    public static final int C_STORE_REQUEST_SEND = 9;
    public static final int C_STORE_REQUEST_RECEIVE = 19;
    public static final int C_STORE_RESPONSE = 10;
    public static final int C_STORE_RESPONSE_SEND = 10;
    public static final int C_STORE_RESPONSE_RECEIVE = 18;
    public static final int C_FIND_REQUEST = 11;
    public static final int C_FIND_REQUEST_SEND = 11;
    public static final int C_FIND_RESPONSE = 12;
    public static final int C_FIND_RESPONSE_RECEIVE = 12;
    public static final int C_CANCEL_REQUEST = 13;
    public static final int C_CANCEL_REQUEST_SEND = 13;
    public static final int C_MOVE_REQUEST = 14;
    public static final int C_MOVE_REQUEST_SEND = 14;
    public static final int C_MOVE_RESPONSE = 15;
    public static final int C_MOVE_RESPONSE_RECEIVE = 15;
    public static final int C_GET_REQUEST = 16;
    public static final int C_GET_REQUEST_SEND = 16;
    public static final int C_GET_RESPONSE = 17;
    public static final int C_GET_RESPONSE_RECEIVE = 17;
    public static final int START = 1;
    public static final int END = 2;
    private int step;
    private int phase;
    private Object object;

    public SCUProgressEvent(int step, int phase) {
        this(step, phase, null);
    }

    public SCUProgressEvent(int step, int phase, Object object) {
        this.step = step;
        this.phase = phase;
        this.object = object;
    }

    public int getStep() {
        return this.step;
    }

    public int getPhase() {
        return this.phase;
    }

    public Object getObject() {
        return this.object;
    }

    public String getMessage() {
        String msg = this.phase == 1 ? "START " : "END ";
        switch (this.step) {
            case 1: {
                msg = msg + "OPEN SOCKET";
                break;
            }
            case 2: {
                msg = msg + "ASSOCIATE REQUEST";
                break;
            }
            case 3: {
                msg = msg + "ASSOCIATE RESPONSE";
                break;
            }
            case 4: {
                msg = msg + "C-ECHO REQUEST SEND";
                break;
            }
            case 5: {
                msg = msg + "C-ECHO RESPONSE RECEIVE";
                break;
            }
            case 6: {
                msg = msg + "ASSOCIATE RELEASE REQUEST";
                break;
            }
            case 7: {
                msg = msg + "ASSOCIATE RELEASE RESPONSE";
                break;
            }
            case 8: {
                msg = msg + "CLOSE SOCKET";
                break;
            }
            case 9: {
                msg = msg + "C-STORE REQUEST SEND";
                break;
            }
            case 19: {
                msg = msg + "C-STORE REQUEST RECEIVE";
                break;
            }
            case 10: {
                msg = msg + "C-STORE RESPONSE SEND";
                break;
            }
            case 18: {
                msg = msg + "C-STORE RESPONSE RECEIVE";
                break;
            }
            case 11: {
                msg = msg + "C-FIND REQUEST SEND";
                break;
            }
            case 12: {
                msg = msg + "C-FIND RESPONSE RECEIVE";
                break;
            }
            case 13: {
                msg = msg + "C-CANCEL REQUEST SEND";
                break;
            }
            case 14: {
                msg = msg + "C-MOVE REQUEST SEND";
                break;
            }
            case 15: {
                msg = msg + "C-MOVE RESPONSE RECEIVE";
                break;
            }
            default: {
                msg = msg + "UNKNOWN";
            }
        }
        return msg;
    }

    public String toString() {
        return "SCUProgressEvent [" + this.getMessage() + "]";
    }
}

