/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.uid;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;

public class UIDGenerator {
    private static final Random rnd = new Random();
    private static String lastUID;
    private static long lastTime;
    private static long counter;
    private static final String UID_REGEX = "(0|([1-9]\\d*))(\\.(0|([1-9]\\d*)))*\\.?";
    private static long macAddress;

    public static synchronized String generate(String prefix, boolean useMacAddress) {
        if (!UIDGenerator.isValidPrefix(prefix)) {
            throw new IllegalArgumentException("prefixes should follow the DICOM UID format rules");
        }
        StringBuffer sb = new StringBuffer(prefix);
        if (sb.charAt(sb.length() - 1) != '.') {
            sb.append('.');
        }
        if (sb.length() > 31) {
            throw new IllegalArgumentException("prefixes (including trailing '.') cannot exceed 31 bytes in length");
        }
        sb.append(UIDGenerator.formatLong(UIDGenerator.getMacAddress(useMacAddress), 15, true));
        sb.append('.');
        if (counter == 999L) {
            boolean done = false;
            while (!done) {
                long now = System.currentTimeMillis();
                if (now <= lastTime) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                done = true;
            }
        }
        lastTime = System.currentTimeMillis();
        sb.append(UIDGenerator.formatLong(lastTime, 14, true));
        String s = sb.toString();
        if (s.equals(lastUID)) {
            lastUID = s;
            return lastUID + UIDGenerator.formatLong(++counter, 3, false);
        }
        lastUID = s;
        counter = 0L;
        return s + "000";
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(UIDGenerator.generate("1.2.3.4.5.6.7.8.9", true));
        } else {
            System.out.println(UIDGenerator.generate(args[0], true));
        }
    }

    private static boolean isValidPrefix(String prefix) {
        return prefix != null && prefix.matches(UID_REGEX);
    }

    private static String formatLong(long l, int maxLen, boolean trailing) {
        String s = Long.toString(l);
        int stringLen = s.length();
        if (maxLen < stringLen) {
            return s.substring(stringLen - maxLen);
        }
        for (int i = 0; i < maxLen - stringLen; ++i) {
            s = trailing ? s + "0" : "0" + s;
        }
        return s;
    }

    private static long getMacAddress(boolean realMacAddress) {
        if (realMacAddress) {
            if (macAddress == -1L) {
                macAddress = UIDGenerator.toLong(UIDGenerator.getFirstMacAddressWithJdk());
            }
            return macAddress;
        }
        byte[] bytes = new byte[6];
        rnd.nextBytes(bytes);
        return UIDGenerator.toLong(bytes);
    }

    private static long toLong(byte[] bytes) {
        long l = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            l <<= 8;
            l |= (long)bytes[i] & 0xFFL;
        }
        return l;
    }

    private static byte[] getFirstMacAddressWithJdk() {
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                return mac;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception when obtaining hardware MAC address", ex);
        }
        throw new RuntimeException("Unable to obtain MAC address");
    }

    static {
        macAddress = -1L;
    }
}

