/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.tool;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.MultiVRInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FragmentsInputStream
extends InputStream {
    private int remaining = 0;
    private boolean delimitationItem = false;
    private MultiVRInputStream multiVRInputStream;
    private byte[] buffer = new byte[1];

    public FragmentsInputStream(MultiVRInputStream in) {
        this.multiVRInputStream = in;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.remaining, this.multiVRInputStream.available());
    }

    @Override
    public int read() throws IOException {
        int r = this.read(this.buffer);
        return r == -1 ? -1 : this.buffer[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0 && !this.delimitationItem) {
            try {
                long fragmentLength = this.multiVRInputStream.peekFragmentHeader();
                if (fragmentLength == -1L) {
                    this.remaining = 8;
                    this.delimitationItem = true;
                } else {
                    this.remaining = (int)fragmentLength + 8;
                }
            }
            catch (DicomException e) {
                throw new IOException(e);
            }
        }
        if (this.remaining == -1) {
            return -1;
        }
        int r = this.multiVRInputStream.read(b, off, Math.min(this.remaining, len));
        this.remaining -= r;
        if (this.remaining == 0 && this.delimitationItem) {
            this.remaining = -1;
        }
        return r;
    }
}

