/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.base.OnportAlphaSliderVc;
import com.ge.med.cse.cvf.idc.AlphaBlender;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.cpanels.J3DThkPagingPopPanel;
import com.ge.med.cse.cvf.util.CvFusionPixelCombiner;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MVFusionJ3DPort
extends J3DViewport
implements Fusion3DCapable {
    OnportAlphaSliderVc fusionSlider = null;
    XpVisualComponent sliderHoldingComponent = new XpVisualComponent();
    int fusedLayer = 1;

    @Override
    public void resetWindowing() {
        super.resetWindowing();
        if (this.isCTPETFused()) {
            this.setVideoInverted(false);
            this.applyHotCmap();
        }
    }

    public int getFusionlayer() {
        return this.fusedLayer;
    }

    private void applyHotCmap() {
        int[] cMap = null;
        try {
            cMap = CvImageFusionUtils.loadRGBColorTable(CvImageLoader.class.getResourceAsStream("/com/ge/med/cse/cvf/util/hot.cm"));
            this.setColorMap(cMap);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isCTPETFused() {
        String modality = DicomUtils.getModality(this.getVolume());
        if (this.getVolume(this.fusedLayer) == null) {
            return false;
        }
        String layerModality = DicomUtils.getModality(this.getVolume(this.fusedLayer));
        return "PT".equalsIgnoreCase(modality) && "CT".equalsIgnoreCase(layerModality);
    }

    private void removeFusionSlider() {
        this.getT3DComponent().remove(this.sliderHoldingComponent);
    }

    private void addFisionSlider() {
        FadeAwayOverLay fadeAwayOverLay;
        if (this.fusionSlider == null) {
            XjFusionPixelCombiner pixelCombiner = null;
            String pixelCombinerstr = CvPropertiesManager.getProperty("PixelCombiner", CvFusionPixelCombiner.class.getName());
            try {
                pixelCombiner = (XjFusionPixelCombiner)Thread.currentThread().getContextClassLoader().loadClass(pixelCombinerstr).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setPixelCombiner(pixelCombiner);
            this.fusionSlider = new OnportAlphaSliderVc((AlphaBlender)((Object)pixelCombiner)){

                @Override
                protected void setSliderPosition() {
                    this.slider.setName("MVAlphaSlider");
                    this.slider.setOrientation(0);
                    final JLabel sliderPosIndicator = new JLabel();
                    sliderPosIndicator.setName("MVAlphaLabel");
                    sliderPosIndicator.setForeground(Color.CYAN);
                    JPanel tempPanel = new JPanel(new BorderLayout());
                    tempPanel.setOpaque(false);
                    tempPanel.add((Component)sliderPosIndicator, "South");
                    JPanel indicatorPanel = new JPanel(new BorderLayout());
                    indicatorPanel.add((Component)tempPanel, "East");
                    indicatorPanel.add(this.slider);
                    indicatorPanel.setOpaque(false);
                    JPanel pan = new JPanel();
                    pan.setOpaque(false);
                    pan.setLayout(new GridLayout(2, 1));
                    pan.add(new JLabel(""));
                    pan.add(indicatorPanel);
                    this.add((Component)pan, "South");
                    pan.repaint();
                    sliderPosIndicator.setText("  " + this.slider.getValue() + " %");
                    this.slider.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            sliderPosIndicator.setText("  " + slider.getValue() + " %");
                        }
                    });
                }
            };
        }
        if ((fadeAwayOverLay = (FadeAwayOverLay)this.getClientProperty("FadeAwayOverLay")) != null) {
            Component[] com;
            for (Component co : com = fadeAwayOverLay.getOnPortComponents()) {
                if (!(co instanceof J3DThkPagingPopPanel)) continue;
                ((J3DThkPagingPopPanel)co).setThicknessControlEnabled(false);
                break;
            }
        }
        this.sliderHoldingComponent.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.sliderHoldingComponent.setSize(this.getWidth(), this.getHeight());
        this.sliderHoldingComponent.setLayout(new BorderLayout());
        this.sliderHoldingComponent.add((Component)this.fusionSlider, "West");
        this.getT3DComponent().add(this.sliderHoldingComponent);
        this.getT3DComponent().revalidate();
        this.revalidate();
    }

    @Override
    public int addVolumeLayer(XjVolumeInfo volInfo) {
        int result;
        this.fusedLayer = result = this.getT3DComponent().addVolumeLayer(volInfo);
        if (this.isCTPETFused()) {
            this.setVideoInverted(false);
            this.applyHotCmap();
            this.addFisionSlider();
        }
        return result;
    }

    @Override
    public void setVolumeModel(XjVolumeModel vm) {
        int layer = this.getNumVolumeLayers();
        if (layer > 0) {
            for (int i = layer; i >= 0; --i) {
                this.removeVolumeLayer(i);
            }
            this.removeFusionSlider();
        }
        this.setColorMap(null);
        super.setVolumeModel(vm);
    }

    @Override
    public void setVolume(XjVolumeInfo volume) {
        this.setColorMap(null);
        super.setVolume(volume);
    }

    @Override
    public int addVolumeLayer(XjVolumeModel volModel) {
        int result;
        this.fusedLayer = result = this.getT3DComponent().addVolumeLayer(volModel);
        if (this.isCTPETFused()) {
            this.setVideoInverted(false);
            this.applyHotCmap();
            this.addFisionSlider();
        }
        return result;
    }

    @Override
    public void setVolumeLayer(XjVolumeInfo volInfo, int layer) {
        this.getT3DComponent().setVolumeLayer(volInfo, layer);
    }

    @Override
    public void setVolumeLayer(XjVolumeModel volModel, int layer) {
        this.getT3DComponent().setVolumeLayer(volModel, layer);
    }

    @Override
    public XjVolumeInfo getVolume(int layerNo) {
        return this.getT3DComponent().getVolume(layerNo);
    }

    @Override
    public XjVolumeModel getVolumeModel(int layerNo) {
        return this.getT3DComponent().getVolumeModel(layerNo);
    }

    @Override
    public int removeVolumeLayer(int layer) {
        this.getT3DComponent().remove(this.sliderHoldingComponent);
        return this.getT3DComponent().removeVolumeLayer(layer);
    }

    @Override
    public void selectVolumeLayer(int layer) {
        this.getT3DComponent().selectVolumeLayer(layer);
    }

    @Override
    public int getVolumeLayer() {
        return this.getT3DComponent().getVolumeLayer();
    }

    @Override
    public int getNumVolumeLayers() {
        int result = this.getT3DComponent().getNumVolumeLayers();
        return result;
    }

    @Override
    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.getT3DComponent().setPixelCombiner(fpc);
    }

    @Override
    public XjFusionPixelCombiner getPixelCombiner() {
        return this.getT3DComponent().getPixelCombiner();
    }
}

