/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.cse.apps.cdviewer.DMPhaseObject;
import com.ge.med.cse.apps.cdviewer.MVAppConstants;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.terra.tap.dm.DMObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class PhaseTableRowObject {
    private DMObject[] refImages;
    private DMObject phaseObject;
    private String description = null;

    public PhaseTableRowObject(DMObject[] phaseDMObject, DMObject refSeries) {
        this.refImages = phaseDMObject;
        this.phaseObject = new DMPhaseObject(phaseDMObject, refSeries);
    }

    public String getSeriesDescription() {
        if (this.description == null) {
            if (CvImageFusionUtils.isPETSeriesTypeGATED(this.refImages[0])) {
                int framingType = CvImageFusionUtils.getFramingType(this.refImages[0]);
                this.description = framingType == 1113 || framingType == 1112 ? MVAppConstants.I18N.TRIG_TIME + " " + CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.TRIGGER_TIME_DMTAG) + "ms" : MVAppConstants.I18N.PHASE_ + CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.FRAME_PHASE_PERCENT) + "%";
            } else {
                double time = Double.parseDouble(CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.FRAME_REFERENCE_TIME_DMTAG).toString());
                this.description = "Ref Time: " + this.timeFormat("HH:mm:ss", time / 1000.0);
            }
        }
        return this.description;
    }

    protected String timeFormat(String format, double hhmmss) {
        int ss = (int)hhmmss % 100;
        int mm = (int)(hhmmss /= 100.0) % 100;
        int hh = (int)(hhmmss /= 100.0);
        Calendar cal = Calendar.getInstance();
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        Date date = new Date();
        date = cal.getTime();
        SimpleDateFormat dateFormatter = new SimpleDateFormat();
        dateFormatter.applyPattern(format);
        String result = dateFormatter.format(date);
        return result;
    }

    public DMObject getDMObject() {
        return this.phaseObject;
    }
}

