/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.ui;

import com.ge.med.cse.cvf.controls.CvMouseControlManager;
import com.ge.med.cse.cvf.controls.CvMouseController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;

public class MouseMenuToolBarController
implements ActionListener {
    private HashMap<String, Integer> mouseActionCmds = new HashMap();
    final int ICON_SIZE = 20;
    List<JButton> mouseMenuOptions = new ArrayList<JButton>();
    CvMouseController cvMouseController = null;
    private static int currentSelectedMode = -1;
    private CvMouseControlManager mcManager = CvMouseControlManager.getInstance();
    private HashMap<Integer, JButton> mouseControllers = new HashMap();
    PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode = MouseMenuToolBarController.this.mcManager.getMouseMode();
            if (currentSelectedMode != newMode) {
                if (MouseMenuToolBarController.this.mouseControllers.get(currentSelectedMode) != null) {
                    ((JButton)MouseMenuToolBarController.this.mouseControllers.get(currentSelectedMode)).setSelected(false);
                }
                currentSelectedMode = newMode;
                if (MouseMenuToolBarController.this.mouseControllers.get(newMode) != null) {
                    ((JButton)MouseMenuToolBarController.this.mouseControllers.get(newMode)).setSelected(true);
                }
            }
        }
    };

    public MouseMenuToolBarController(CvMouseController cvMouseController) {
        this.cvMouseController = cvMouseController;
        try {
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createController();
    }

    public void createController() {
        int[] modes;
        for (int mode : modes = this.cvMouseController.getSupportedModes()) {
            JButton btn = new JButton();
            btn.addActionListener(this);
            btn.setIcon((Icon)this.cvMouseController.getModeProperty(mode, "icon_property"));
            btn.setToolTipText((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            btn.setActionCommand((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            btn.setName((String)this.cvMouseController.getModeProperty(mode, "name_property"));
            this.mouseControllers.put(mode, btn);
            this.mouseActionCmds.put(btn.getActionCommand(), mode);
            this.mouseMenuOptions.add(btn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newMode = this.mouseActionCmds.get(e.getActionCommand());
        if (newMode != -1 && currentSelectedMode != newMode) {
            if (this.mouseControllers.get(currentSelectedMode) != null) {
                this.mouseControllers.get(currentSelectedMode).setSelected(false);
            }
            currentSelectedMode = newMode;
            if (this.mouseControllers.get(newMode) != null) {
                this.mouseControllers.get(newMode).setSelected(true);
            }
            this.mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
            CvMouseControlManager.getInstance().setMouseMode(newMode);
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
    }

    public List<JButton> getMouseMenuOptions() {
        return this.mouseMenuOptions;
    }
}

