/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.aac;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CVAAZoom
implements ActiveAnnotationControl {
    protected static final Logger logger = Logger.getLogger(ActiveAnnotationControl.class.getName());
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_AA_ZOOM");
    private DecimalFormat df = new DecimalFormat("###0.0");
    private JPopupMenu popup = new JPopupMenu();
    private SliderMenuItem _smi = null;
    protected PanZoomCapable zoomCap = null;
    private double MIN_ZOOM = CvUtils.getMinZoom();
    private double MAX_ZOOM = CvUtils.getMaxZoom();

    public CVAAZoom() {
        this._smi = new SliderMenuItem(1, (int)(this.MIN_ZOOM * 100.0), (int)(this.MAX_ZOOM * 100.0), 100);
        this._smi.setName(CVAAZoom.class.getName() + "_smi");
        this._smi.setFocusable(false);
        this._smi.setInputMap(0, new InputMap());
        this.popup.add(this._smi);
        this.popup.setName("Magnification");
    }

    @Override
    public String getShortDescription() {
        return CvUtils.getResourceBundle().getString("AA_ZOOM_TOOLTIP");
    }

    @Override
    public void listenTo(Component c) {
        if (c instanceof Capable) {
            this.setCapable((Capable)((Object)c));
        }
    }

    @Override
    public void setCapable(Capable capable) {
        this.zoomCap = (PanZoomCapable)capable.getCapable(PanZoomCapable.class.getName());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    protected void setZoom(double zoom) {
        if (this.zoomCap != null) {
            this.zoomCap.setZoom(zoom);
            this.zoomCap.repaint();
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        this.zoomCap = (PanZoomCapable)((Object)SwingUtilities.getAncestorOfClass(PanZoomCapable.class, e.getComponent()));
        if (e.isPopupTrigger() && this.zoomCap != null) {
            this._smi.setValue((int)(this.zoomCap.getZoom() * 100.0));
            if (!this.popup.isShowing()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY() + 15);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    class SliderMenuItem
    extends JSlider
    implements ChangeListener {
        public SliderMenuItem(int orientation, int min, int max, int initval) {
            super(orientation, min, max, initval);
            this.addChangeListener(this);
            NumberFormat numberFormatter = NumberFormat.getNumberInstance();
            numberFormatter.setMinimumFractionDigits(1);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer((int)(CVAAZoom.this.MIN_ZOOM * 100.0)), new JLabel("" + numberFormatter.format(CVAAZoom.this.MIN_ZOOM)));
            labelTable.put(new Integer(100), new JLabel("" + numberFormatter.format(1.0)));
            labelTable.put(new Integer((int)(CVAAZoom.this.MAX_ZOOM * 100.0 * 1.0 / 4.0)), new JLabel("" + numberFormatter.format(CVAAZoom.this.MAX_ZOOM / 4.0)));
            labelTable.put(new Integer((int)(CVAAZoom.this.MAX_ZOOM * 100.0 / 2.0)), new JLabel("" + numberFormatter.format(CVAAZoom.this.MAX_ZOOM / 2.0)));
            labelTable.put(new Integer((int)(CVAAZoom.this.MAX_ZOOM * 100.0 * 3.0 / 4.0)), new JLabel("" + numberFormatter.format(CVAAZoom.this.MAX_ZOOM * 3.0 / 4.0)));
            labelTable.put(new Integer((int)(CVAAZoom.this.MAX_ZOOM * 100.0)), new JLabel(numberFormatter.format(CVAAZoom.this.MAX_ZOOM)));
            this.setLabelTable(labelTable);
            this.setMinorTickSpacing(100);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                int val = this.getValue();
                double zoom = (double)val / 100.0;
                String zo = CVAAZoom.this.df.format(zoom);
                NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                Number number = numberFormatter.parse(zo);
                zoom = number.doubleValue();
                CVAAZoom.this.setZoom(zoom);
                logger.log(Level.FINEST, "{0} Set zoom factor to " + zoom, tln);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

