/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class XpColorMapAction
extends BaseAction {
    private int[] colortable = null;
    private Dimension dim = new Dimension(40, 10);

    @Override
    protected String getName() {
        return "XP_COLORMAP";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ColorMapCapable cmc = this.getColorMapCapable();
            if (cmc == null) {
                this.getLogger().log(Level.WARNING, "Target is null");
                return;
            }
            String[] params = this.getParams();
            String colname = this.parseParams(params);
            if (colname != null) {
                WindowLevelCapable wlc = this.getWindowLevelCapable();
                if (colname.equalsIgnoreCase("none") || colname.equalsIgnoreCase("gray")) {
                    cmc.setColorMap(null);
                } else if (colname.equalsIgnoreCase("inverse gray")) {
                    cmc.setColorMap(null);
                    wlc.setVideoInverted(true);
                } else if (this.colortable != null) {
                    if (cmc instanceof FrameCapable) {
                        FrameCapable fc = (FrameCapable)((Object)cmc);
                        if (fc.getFrame() != null && CvUtils.measurementsValid(fc.getFrame())) {
                            cmc.setColorMap(this.colortable);
                        } else {
                            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
                        }
                    }
                } else {
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                }
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Invalid colormap command argument", ex);
        }
        this.setParams(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseParams(String[] params) {
        if (params == null) return null;
        int length = params.length;
        if (length <= 0) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            return null;
        }
        if (length > 2) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
            return null;
        }
        if (length != 2) {
            if (length != 1) return null;
            return params[0];
        }
        if (params[0].equalsIgnoreCase("inverse") && params[1].equalsIgnoreCase("gray")) {
            return "inverse gray";
        }
        this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParams(String[] params) {
        super.setParams(params);
        InputStream inStream = null;
        if (params == null || params.length == 0) {
            this.colortable = null;
            return;
        }
        try {
            String colname = this.parseParams(params);
            if (colname != null) {
                colname = colname.toLowerCase();
                String[] allMaps = CvPropertiesManager.getProperty("cvf.colormaps", "gray,blue,colder,cool,hot,hotter,isocontour,prism,rainbow,thermal,none").toLowerCase().split(",");
                List<String> cmapList = Arrays.asList(allMaps);
                if (cmapList.contains(colname)) {
                    if (CvPropertiesManager.getProperty("cvf.colormaps." + colname) != null) {
                        String filePath = CvPropertiesManager.getProperty("cvf.colormaps." + colname);
                        File cmapFile = new File(filePath);
                        if (cmapFile.exists()) {
                            if (filePath.endsWith(".cm")) {
                                inStream = new FileInputStream(filePath);
                                this.colortable = CvImageFusionUtils.loadRGBColorTable(inStream);
                            } else {
                                this.colortable = XPutil.getColorTable(filePath);
                            }
                        } else {
                            inStream = XpColorMapAction.class.getResourceAsStream(filePath);
                            if (inStream != null) {
                                this.colortable = CvImageFusionUtils.loadRGBColorTable(inStream);
                            }
                        }
                    } else {
                        inStream = XpColorMapAction.class.getResourceAsStream("/com/ge/med/cse/cvf/util/" + params[0].trim() + ".cm");
                        this.colortable = inStream != null ? CvImageFusionUtils.loadRGBColorTable(inStream) : XPutil.getColorTable(colname);
                    }
                    if (this.colortable != null) {
                        this.setIcon(CvImageFusionUtils.createColorMapIcon(this.colortable, this.dim));
                        this.setName(CvUtils.getResourceBundle().getString(params[0] + "_NAME"));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Invalid colormap command argument", ex);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

