/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.xpv.cuiPanels.ImageFilter;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpFilterAction
extends BaseAction {
    private XpImageOp iop = null;
    private boolean none = false;

    @Override
    protected String getName() {
        return "XP_FILTER";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FrameCapable fc;
        ImageOpCapable imageOp = this.getImageOpCapable();
        if (!(!(imageOp instanceof FrameCapable) || (fc = (FrameCapable)((Object)imageOp)).getFrame() == null || CvUtils.measurementsValid(fc.getFrame()) && CvUtils.isGSEFilterValid(fc.getFrame()))) {
            this.getLogger().log(Level.INFO, "unsupported image type");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        try {
            String[] params = this.getParams();
            if (params != null && params.length > 0) {
                this.iop = this.parseParams(params);
                if (this.iop != null) {
                    imageOp.clearImageOps();
                    imageOp.addImageOp(this.iop);
                    ((JComponent)((Object)this.getCapable())).putClientProperty("filter", params[0]);
                } else if (this.none) {
                    imageOp.clearImageOps();
                    ((JComponent)((Object)this.getCapable())).putClientProperty("filter", "None");
                    this.none = false;
                } else {
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                    this.getLogger().log(Level.WARNING, "Invalid filter argument");
                }
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
                this.getLogger().log(Level.WARNING, "Invalid Filter command.");
            }
            this.setParams(null);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "", ex);
        }
    }

    private XpImageOp parseParams(String[] params) {
        if (params.length > 1) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
            this.getLogger().log(Level.WARNING, "Too many parameters");
            return null;
        }
        if (params[0].equalsIgnoreCase("none")) {
            this.none = true;
            return null;
        }
        if (params[0].equalsIgnoreCase("e1")) {
            return ImageFilter.E1();
        }
        if (params[0].equalsIgnoreCase("e2")) {
            return ImageFilter.E2();
        }
        if (params[0].equalsIgnoreCase("e21")) {
            return ImageFilter.E21();
        }
        if (params[0].equalsIgnoreCase("e22")) {
            return ImageFilter.E22();
        }
        if (params[0].equalsIgnoreCase("e23")) {
            return ImageFilter.E23();
        }
        if (params[0].equalsIgnoreCase("e3")) {
            return ImageFilter.E3();
        }
        if (params[0].equalsIgnoreCase("s1")) {
            return ImageFilter.S1();
        }
        if (params[0].equalsIgnoreCase("s11")) {
            return ImageFilter.S11();
        }
        if (params[0].equalsIgnoreCase("s2")) {
            return ImageFilter.S2();
        }
        if (params[0].equalsIgnoreCase("s21")) {
            return ImageFilter.S21();
        }
        if (params[0].equalsIgnoreCase("s3")) {
            return ImageFilter.S3();
        }
        if (params[0].equalsIgnoreCase("lung") || params[0].equalsIgnoreCase("lu")) {
            return ImageFilter.lung();
        }
        return null;
    }
}

