/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpFormatAction
extends BaseAction {
    int maxcol = 5;
    int maxrow = 5;

    @Override
    protected String getName() {
        return "XP_FORMAT";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String[] params = this.getParams();
            if (params != null && params.length > 0) {
                JComponent port;
                CineCapable cc = this.getCineCapable();
                if (cc != null && cc.getCine()) {
                    this.getLogger().log(Level.WARNING, "Cannot apply format command. Cine On.");
                    return;
                }
                for (port = (XPscreen)this.getCapable(); port != null && port instanceof XPscreen; port = port.getSelectedPort()) {
                }
                if (port == null || !(port instanceof RowColCapable)) {
                    this.getLogger().log(Level.INFO, "Cannot apply format command. Not a RowColCapable port.");
                    return;
                }
                int row = Integer.parseInt(params[0]);
                int col = Integer.parseInt(params[1]);
                if (row < 1 || row > this.maxrow || col < 1 || col > this.maxcol) {
                    this.getLogger().log(Level.INFO, "Cannot apply format command. Invalid format option");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_FORMAT"));
                    return;
                }
                ((RowColCapable)((Object)port)).setRowCol(row, col);
                ((XPscreen)this.getCapable()).firePropertyChange("format_changed", false, true);
                this.setParams(null);
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.getLogger().log(Level.WARNING, "Invalid arguments for the command format");
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Invalid format command", ex);
        }
    }
}

