/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvFreeHandRoi;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreationListener;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class XpFreeHandROIAction
extends BaseAction
implements ComponentCreationListener {
    private static final Logger logger = Logger.getLogger(XpFreeHandROIAction.class.getName());
    private static final boolean imageCalibration = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.imageCalibration", "false"));
    private boolean calibrated = true;
    private AbstractButton button = null;

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
    }

    @Override
    protected String getName() {
        return "XP_FREEHAND_ROI";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpImage img;
        JComponent port;
        logger.log(Level.INFO, "XpFreeHandROIAction.actionPerformed()");
        XjVolumeCapable volCap = (XjVolumeCapable)this.getCapable().getCapable(XjVolumeCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (!(volCap != null || frameCapable != null && CvUtils.measurementsValid(frameCapable.getFrame()))) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
            return;
        }
        if (imageCalibration && (port = this.getSelectedViewport()) != null && !(port instanceof T3DCapable) && port instanceof FrameOwner && (img = ((FrameOwner)((Object)port)).getFrame()) instanceof XpDicomObject) {
            XpDicomObject dicomObj = (XpDicomObject)((Object)img);
            boolean bl = this.calibrated = !CvUtils.needCalibration(dicomObj);
        }
        if (imageCalibration && !this.calibrated) {
            String message = CvUtils.getResourceBundle().getString("ROI_NOT_SUPPORTED");
            JComponent comp = this.getSelectedMainViewport();
            JOptionPane.showMessageDialog(comp, message);
        } else {
            Point2D pt = null;
            String[] params = this.getParams();
            if (params != null && params.length > 0) {
                pt = this.parseParams(params);
                this.setParams(null);
                if (pt != null) {
                    this.getROICapable().add(new CvFreeHandRoi(pt.getX(), pt.getY()));
                } else {
                    this.getLogger().log(Level.WARNING, "Angle Points returned NULL.");
                }
            } else {
                if (e.getSource() instanceof AbstractButton) {
                    this.button = (AbstractButton)e.getSource();
                    this.button.setEnabled(false);
                }
                try {
                    ComponentCreator cc = CvFreeHandRoi.getComponentCreator(0);
                    cc.addComponentCreationListener(this);
                    ComponentCapable compCap = this.getComponentCapable();
                    compCap.setAutoRepaint(true);
                    compCap.setComponentCreator(cc);
                }
                catch (Exception exp) {
                    this.getLogger().log(Level.WARNING, "Error during polygon roi action creation, ", exp);
                }
            }
        }
    }

    private Point2D parseParams(String[] st) {
        if (st.length != 2) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            this.getLogger().log(Level.WARNING, "Invalid command arguments");
        } else {
            try {
                int x = Integer.parseInt(st[0]);
                int y = Integer.parseInt(st[1]);
                Point2D pt = new Point2D.Double(x, y);
                pt = CvUtils.getValidImagePoint(pt, this.getROICapable());
                return pt;
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Unable to parse argument", e);
            }
        }
        return null;
    }

    @Override
    public void componentAddedNotification(ComponentCapable cc) {
        if (this.button != null) {
            this.button.setEnabled(true);
        }
    }

    @Override
    public void componentCreationNotification(ComponentCapable cc) {
    }
}

