/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class XpSaveAsJPEGAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame parent = null;
        if (e.getSource() instanceof AbstractButton) {
            Container parentComp = ((AbstractButton)e.getSource()).getParent();
            if (parentComp instanceof JPopupMenu) {
                JPopupMenu popup = (JPopupMenu)parentComp;
                parent = (JFrame)SwingUtilities.getWindowAncestor(popup.getInvoker());
            } else {
                parent = (JFrame)SwingUtilities.getWindowAncestor((JComponent)e.getSource());
            }
        }
        try {
            String finalpath = this.getPathToSave(parent);
            if (finalpath != null) {
                JComponent comp = this.getSelectionCapable().getViewportComponent(this.getSelectionCapable().getComponentSelection());
                if (comp instanceof XpSeriesDisplayer) {
                    XpSeriesDisplayer serDisp = (XpSeriesDisplayer)comp;
                    XpFrameVisualizer saveFrame = serDisp.getSelectedPort();
                    BufferedImage viewerImage = new BufferedImage(saveFrame.getWidth(), saveFrame.getHeight(), 5);
                    saveFrame.paint(viewerImage.getGraphics());
                    if (finalpath.endsWith(".jpg") || finalpath.endsWith(".jpeg")) {
                        ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                    } else if (finalpath.endsWith(".png")) {
                        ImageIO.write((RenderedImage)viewerImage, "png", new File(finalpath));
                    } else {
                        finalpath = finalpath + ".jpeg";
                        ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                    }
                } else if (comp instanceof J3DViewport) {
                    J3DViewport j3dVp = (J3DViewport)comp;
                    BufferedImage viewerImage = new BufferedImage(j3dVp.getWidth(), j3dVp.getHeight(), 5);
                    j3dVp.paint(viewerImage.getGraphics());
                    if (finalpath.endsWith(".jpg") || finalpath.endsWith(".jpeg")) {
                        ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                    } else if (finalpath.endsWith(".png")) {
                        ImageIO.write((RenderedImage)viewerImage, "png", new File(finalpath));
                    } else {
                        finalpath = finalpath + ".jpeg";
                        ImageIO.write((RenderedImage)viewerImage, "jpeg", new File(finalpath));
                    }
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(parent, CvUtils.getResourceBundle().getString("ERROR_FAILED_TO_EXPORT"), "", 0);
            ex.printStackTrace();
        }
    }

    protected String getPathToSave(Component parent) {
        if (System.getProperty("IMAGE_SAVE_PATH") != null) {
            return System.getProperty("IMAGE_SAVE_PATH");
        }
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new JPEGFileFilter());
        jfc.setAcceptAllFileFilterUsed(false);
        int selectedOpetion = jfc.showSaveDialog(parent);
        if (selectedOpetion == 0) {
            File saveFile = jfc.getSelectedFile();
            return saveFile.getAbsolutePath();
        }
        return null;
    }

    @Override
    protected String getName() {
        return "XP_EXPORT_AS_JPEG_PNG";
    }

    private class JPEGFileFilter
    extends FileFilter {
        private JPEGFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".jpeg") | filename.endsWith(".jpg") || file.isDirectory() || filename.endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "*.jpeg , *.png";
        }
    }
}

