/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpWindowWidthAction
extends BaseAction {
    protected double WW_MIN;
    protected double WW_MAX;

    @Override
    protected String getName() {
        return "XP_WINDOW_WIDTH";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XpMedicalImage dmImage = this.getFrame();
        this.WW_MIN = CvUtils.getMinWW(dmImage);
        this.WW_MAX = CvUtils.getMaxWW(dmImage);
        double wl = (this.getWindowLevelCapable().getWinMax() + this.getWindowLevelCapable().getWinMin()) / 2.0;
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                Double ww = Double.parseDouble(params[0]);
                this.setWindowing(wl, ww);
                this.setParams(null);
            } else {
                this.getLogger().log(Level.WARNING, "Missing WW argument");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Parsing error for WW argument", ex);
        }
    }

    public void setWindowing(double wl, double ww) {
        if (ww > this.WW_MAX) {
            ww = this.WW_MAX;
        } else if (ww < this.WW_MIN) {
            ww = this.WW_MIN;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }
}

