/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.StdAnno.ApStyle;
import com.ge.med.cse.cvf.annotation.XpCVAnnotation;
import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpApdAnnotation;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpRASAnnotation;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JComponent;

public class MRCT3DApdAnnotationConfig
extends XpMRCTApdAnnotationConfig {
    protected DecimalFormat centerFormat = new DecimalFormat();
    protected DecimalFormat thicknessFormat = new DecimalFormat();
    protected DecimalFormat dfovFormat = new DecimalFormat();
    private Dimension size = new Dimension();
    private XpRASAnnotation rasAnno = new XpRASAnnotation();
    private double[] up = new double[3];
    private double[] lookpt = new double[3];
    private double[] eyept = new double[3];
    private CPoint[] cornerPts = new CPoint[3];
    private JnVector3d u = new JnVector3d();
    private JnVector3d r = new JnVector3d();
    private JnVector3d v = new JnVector3d();
    private XpSlice slice = null;

    public MRCT3DApdAnnotationConfig() {
        System.err.println(">>>>>>>>>>>>>>>>>>> MprAnnotationConfig <<<<<<<<<<<<<<<<<<<<<");
        this.centerFormat.setMinimumFractionDigits(2);
        this.centerFormat.setMaximumFractionDigits(2);
        this.centerFormat.setNegativePrefix("");
        this.thicknessFormat.setMinimumFractionDigits(2);
        this.thicknessFormat.setMaximumFractionDigits(2);
        this.thicknessFormat.setNegativePrefix("");
        this.dfovFormat.setMinimumFractionDigits(1);
        this.dfovFormat.setMaximumFractionDigits(1);
        this.dfovFormat.setNegativePrefix("");
        this.cornerPts[0] = new CPoint(0, 0, 0, 2);
        this.cornerPts[1] = new CPoint(1, 0, 0, 2);
        this.cornerPts[2] = new CPoint(1, 1, 0, 2);
        this.slice = new XpSlice(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
    }

    @Override
    public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
        Color activeColor;
        XpAnnotationModel am = avc.getAnnotationModel();
        String str = CvPropertiesManager.getProperty("cvf.activeannotation.color", "yellow");
        if (str != null && (activeColor = CvUtils.getColor(str)) != null) {
            am.setActiveForeground(activeColor);
        }
        am.setProperty("volume", "");
        T3DComponent tc = (T3DComponent)jc;
        if (am == null || tc == null || tc.getVolume() == null) {
            return;
        }
        this.setT3DRASCorners(avc, tc);
        this.setRenderAttributes(avc, tc);
        this.setROIInfo(avc, tc);
        this.setView(avc, tc);
        this.setThkSpacing(avc, tc);
        this.setDfov(avc, tc);
        this.setImageCenter(avc, tc);
    }

    protected void setRenderAttributes(XpAnnotationVc avc, T3DComponent iraOwner) {
        XpAnnotationModel am = avc.getAnnotationModel();
        XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
        if (am != null && ira != null) {
            long ww = (long)ira.getWindowWidth();
            long wl = (long)ira.getWindowLevel();
            am.setProperty("windowWidth", (int)ww);
            am.setProperty("windowLevel", (int)wl);
        }
    }

    protected void setView(XpAnnotationVc annotationVC, T3DComponent t3Component) {
        XpAnnotationModel annoModel = annotationVC.getAnnotationModel();
        ViewTypeCapable vtcap = (ViewTypeCapable)((Object)t3Component.findParentByClass(t3Component, ViewTypeCapable.class));
        if (annoModel != null && vtcap != null) {
            annoModel.setProperty("viewtype", vtcap.getViewType());
        }
    }

    protected void setThkSpacing(XpAnnotationVc annotationVC, T3DComponent t3Component) {
        XpAnnotationModel annoModel = annotationVC.getAnnotationModel();
        T3DViewport viewport = (T3DViewport)t3Component.getParent();
        if (annoModel != null && viewport != null) {
            String rendervalue;
            String thkvalue;
            String strRenderStyle = viewport.getRenderStyle();
            if (strRenderStyle.equals("VOLUME") || strRenderStyle.equals("FULLBODY_MIP") || strRenderStyle.equals("FULLBODY_MINIP") || strRenderStyle.equals("FULLBODY_AVERAGE")) {
                annoModel.setProperty("thickness", "");
                annoModel.setProperty("spacing", "");
                annoModel.setProperty("renderStyle", strRenderStyle);
                return;
            }
            double[] clip = new double[2];
            viewport.getViewClip(clip);
            double thickness = Math.abs(clip[1] - clip[0]);
            short planeType = J3DGeomUtils.getPlaneType(this.slice);
            boolean oblique = planeType == 18 || planeType == 24 || planeType == 20;
            double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(viewport.getVolume(), viewport.getLookPoint(null), viewport.getEyePoint(null), oblique));
            if (thickness > minThickness && !strRenderStyle.startsWith("REFORMAT")) {
                thkvalue = this.thicknessFormat.format(thickness) + "mm";
                rendervalue = strRenderStyle;
            } else {
                thkvalue = this.thicknessFormat.format(minThickness) + "mm";
                rendervalue = "";
            }
            annoModel.setProperty("thickness", thkvalue);
            annoModel.setProperty("spacing", this.thicknessFormat.format(minThickness) + "mm ");
            annoModel.setProperty("renderStyle", rendervalue);
        }
    }

    protected void setDfov(XpAnnotationVc annotationVC, T3DComponent t3Component) {
        XpAnnotationModel annoModel = annotationVC.getAnnotationModel();
        T3DViewport viewport = (T3DViewport)t3Component.getParent();
        if (annoModel != null && viewport != null) {
            double dfovh = viewport.getViewHeight();
            double dfovw = viewport.getAspectRatio() * dfovh;
            String dfovVal = "DFOV: " + this.dfovFormat.format(dfovw / 10.0) + " x " + this.dfovFormat.format(dfovh / 10.0) + " cm";
            annoModel.setProperty("dfov", dfovVal);
        }
    }

    protected void setImageCenter(XpAnnotationVc annotationVC, T3DComponent t3Component) {
        XpAnnotationModel annoModel = annotationVC.getAnnotationModel();
        T3DViewport viewport = (T3DViewport)t3Component.getParent();
        if (annoModel != null && viewport != null) {
            double[] look = viewport.getLookPoint(null);
            short planeType = J3DGeomUtils.getPlaneType(this.slice);
            String strImgCenter = planeType == 2 || planeType == 18 ? (look[2] >= 0.0 ? "S: " + this.centerFormat.format(look[2]) : "I: " + this.centerFormat.format(look[2])) : (planeType == 8 || planeType == 24 ? (look[1] >= 0.0 ? "A: " + this.centerFormat.format(look[1]) : "P: " + this.centerFormat.format(look[1])) : (look[0] >= 0.0 ? "R: " + this.centerFormat.format(look[0]) : "L: " + this.centerFormat.format(look[0])));
            if (planeType == 18 || planeType == 24 || planeType == 20) {
                strImgCenter = strImgCenter + " (coi)";
            }
            annoModel.setProperty("imagecenter", strImgCenter);
            FramePositioningCapable fpc = (FramePositioningCapable)viewport.getCapable(FramePositioningCapable.class.getName());
            if (fpc != null) {
                annoModel.setProperty("imageNumber", "" + (fpc.getFrameIndex() + 1));
            } else {
                annoModel.setProperty("imageNumber", "0");
            }
        }
    }

    private void setT3DRASCorners(XpAnnotationVc avc, T3DComponent tc) {
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        String rasSouth = null;
        String rasNorth = null;
        String rasEast = null;
        String rasWest = null;
        tc.getSize(this.size);
        int w = this.size.width;
        int h = this.size.height;
        int hw = w >> 1;
        int hh = h >> 1;
        double viewHeight = tc.getViewHeight();
        double aspectRatio = tc.getAspectRatio();
        double viewWidth = viewHeight * aspectRatio;
        double spX = viewWidth / (double)w;
        double spY = viewHeight / (double)h;
        tc.getEyePoint(this.eyept);
        tc.getLookPoint(this.lookpt);
        tc.getUp(this.up);
        double len = Math.sqrt(this.up[0] * this.up[0] + this.up[1] * this.up[1] + this.up[2] * this.up[2]);
        this.up[0] = this.up[0] / len;
        this.up[1] = this.up[1] / len;
        this.up[2] = this.up[2] / len;
        this.calc_cam(this.eyept, this.lookpt, this.up);
        this.cornerPts[0].x = this.lookpt[0] + this.up[0] * spY * (double)hh - this.r.x * spX * (double)hw;
        this.cornerPts[0].y = this.lookpt[1] + this.up[1] * spY * (double)hh - this.r.y * spX * (double)hw;
        this.cornerPts[0].z = this.lookpt[2] + this.up[2] * spY * (double)hh - this.r.z * spX * (double)hw;
        this.cornerPts[1].x = this.lookpt[0] + this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
        this.cornerPts[1].y = this.lookpt[1] + this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
        this.cornerPts[1].z = this.lookpt[2] + this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
        this.cornerPts[2].x = this.lookpt[0] - this.up[0] * spY * (double)hh + this.r.x * spX * (double)hw;
        this.cornerPts[2].y = this.lookpt[1] - this.up[1] * spY * (double)hh + this.r.y * spX * (double)hw;
        this.cornerPts[2].z = this.lookpt[2] - this.up[2] * spY * (double)hh + this.r.z * spX * (double)hw;
        this.slice.setCorners(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
        this.rasAnno.set(this.cornerPts[0], this.cornerPts[1], this.cornerPts[2]);
        rasNorth = this.rasAnno.getNorth();
        rasSouth = this.rasAnno.getSouth();
        rasEast = this.rasAnno.getEast();
        rasWest = this.rasAnno.getWest();
        am.setProperty("rasSouth", rasSouth);
        am.setProperty("rasNorth", rasNorth);
        am.setProperty("rasEast", rasEast);
        am.setProperty("rasWest", rasWest);
    }

    private void calc_cam(double[] eyepoint, double[] lookpoint, double[] up) {
        this.v.set(lookpoint[0] - eyepoint[0], lookpoint[1] - eyepoint[1], lookpoint[2] - eyepoint[2]);
        this.v.normalize();
        this.u.set(-up[0], -up[1], -up[2]);
        this.u.normalize();
        JnVector3d.cross(this.u, this.v, this.r);
        this.r.normalize();
        JnVector3d.cross(this.v, this.r, this.u);
        this.u.normalize();
    }

    public static class J3DAnnotationGenerator
    extends XpCVAnnotationGenerator {
        private Vector amvector = new Vector();

        @Override
        public XpApdAnnotation createApdAnnotation(XpDicomObject dobj, ApStyle aps) {
            J3DAnnotation annot = new J3DAnnotation(dobj, aps);
            this.amvector.add(annot);
            return annot;
        }

        @Override
        public void reset() {
            int len = this.amvector.size();
            for (int i = 0; i < len; ++i) {
                J3DAnnotation annot = (J3DAnnotation)this.amvector.get(i);
                annot.dispose();
            }
            this.amvector.clear();
            super.reset();
        }
    }

    private static class J3DAnnotation
    extends XpCVAnnotation {
        public J3DAnnotation(XpDicomObject mi, ApStyle apStyle) {
            super(mi, apStyle);
        }

        @Override
        public XpAnnotationConfig getAnnotationConfig(Class apStyleClass) {
            XpDicomElement modElement = new XpDicomElement(8, 96);
            XpDicomObject mi = this.getDicomObject();
            int result = mi.getValue(modElement);
            String modality = (String)modElement.value;
            if (modality != null && (modality.equalsIgnoreCase("ct") || modality.equalsIgnoreCase("mr"))) {
                return new MRCT3DApdAnnotationConfig();
            }
            return super.getAnnotationConfig();
        }
    }
}

