/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class PleaseWaitDialog
extends JComponent
implements ActionListener {
    private int frame = -1;
    private final int nBars = 8;
    private final float barWidth = 6.0f;
    private final float outerRadius = 28.0f;
    private final float innerRadius = 12.0f;
    private final int trailLength = 4;
    private final float barGray = 200.0f;
    private final Timer timer = new Timer(65, this);
    private final RoundRectangle2D bar = new RoundRectangle2D.Float(12.0f, -3.0f, 28.0f, 6.0f, 6.0f, 6.0f);
    private final double angle = 0.7853981633974483;

    public PleaseWaitDialog(JFrame frm) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        MouseInputAdapter blockMouseEvents = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                evt.consume();
            }
        };
        this.addMouseMotionListener(blockMouseEvents);
        this.addMouseListener(blockMouseEvents);
        this.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent c) {
                return !c.isVisible();
            }
        });
        frm.getRootPane().getLayeredPane().add((Component)this, JLayeredPane.POPUP_LAYER);
        this.setBounds(frm.getBounds());
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        ++this.frame;
        this.repaint();
    }

    public void dispose() {
        this.setVisible(false);
        this.getParent().remove(this);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.requestFocusInWindow();
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 8; ++i) {
            Color barColor = new Color(200, 200, 200);
            if (this.frame != -1) {
                for (int t = 0; t < 4; ++t) {
                    if (i != (this.frame - t + 8) % 8) continue;
                    float tlf = 4.0f;
                    float pct = 1.0f - (tlf - (float)t) / tlf;
                    int gray = (int)(200.0f - pct * 200.0f + 0.5f);
                    barColor = new Color(gray, gray, gray);
                }
            }
            g2d.setColor(barColor);
            g2d.fill(this.bar);
            g2d.rotate(0.7853981633974483);
        }
    }
}

