/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.commands;

import com.ge.med.cse.cvf.commands.CommandObserver;
import com.ge.med.cse.cvf.commands.CommandTableModel;
import com.ge.med.cse.cvf.commands.TextAreaRenderer;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CommandLineHelpDialog
extends JDialog {
    private Object parent = null;
    private JPanel helpPanel = null;
    private ArrayList allaction = new ArrayList();
    private ArrayList refVpaction = new ArrayList();
    private ArrayList cineaction = new ArrayList();
    private String[] columnNames = new String[4];
    private List rowValues;
    private CommandTableModel cm;
    private JTable table;
    private JButton cancel;
    private JButton accept;
    private JPanel tablePanel;
    private JPanel buttonPanel;
    private Border panelBorder = BorderFactory.createEmptyBorder(0, 290, 0, 290);
    private static final String ACCEPT = "ACCEPT";
    private static final String CANCEL = "CANCEL";
    Capable cap_;
    private ArrayList observers = new ArrayList();
    private ActionListener btnl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel lsm;
            if (e.getActionCommand().equals(CommandLineHelpDialog.CANCEL)) {
                CommandLineHelpDialog.this.clearSelection();
                CommandLineHelpDialog.this.setVisible(false);
            }
            if (e.getActionCommand().equals(CommandLineHelpDialog.ACCEPT) && !(lsm = CommandLineHelpDialog.this.table.getSelectionModel()).isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                if ((String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 3) != null) {
                    String cmd = (String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 0);
                    CommandLineHelpDialog.this.clearSelection();
                    CommandLineHelpDialog.this.update(cmd);
                }
            }
        }
    };

    public CommandLineHelpDialog(Object owner) {
        super((Frame)((JFrame)owner), false);
        this.setTitle(CvUtils.getResourceBundle().getString("XP_COMMAND_WND_TITLE"));
        for (int i = 0; i < 4; ++i) {
            this.columnNames[i] = CvUtils.getResourceBundle().getString("Command.Column." + (i + 1) + ".Title");
        }
        this.generateUI();
        this.setContentPane(this.helpPanel);
        this.setSize(new Dimension(800, 512));
        this.parent = owner;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (((XPscreen)CommandLineHelpDialog.this.parent).getSelectedPort() != null) {
                    ((XPscreen)CommandLineHelpDialog.this.parent).getSelectedPort().requestFocusInWindow();
                }
                CommandLineHelpDialog.this.setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                CommandLineHelpDialog.this.clearSelection();
                CommandLineHelpDialog.this.setVisible(false);
            }
        });
    }

    public void setCapable(Capable cap) {
        this.cap_ = cap;
        this.setLocationRelativeTo((Component)((Object)this.cap_));
    }

    public void generateUI() {
        this.createTablePanel();
        this.createButtonPanel();
        this.createDisabledActionOnRefVp();
        this.createDisabledActionOnCine();
        this.helpPanel = new JPanel();
        this.helpPanel.setLayout(new BorderLayout());
        this.helpPanel.setPreferredSize(new Dimension(800, 512));
        this.helpPanel.add((Component)this.tablePanel, "Center");
        this.helpPanel.add((Component)this.buttonPanel, "South");
        this.helpPanel.setName(CommandLineHelpDialog.class.getName() + "helpPanel");
    }

    private void createDisabledActionOnRefVp() {
    }

    private void createDisabledActionOnCine() {
    }

    public ArrayList getAllActions() {
        return this.allaction;
    }

    public ArrayList getDisableActionOnRefVp() {
        return this.refVpaction;
    }

    public ArrayList getDisableActionOnCine() {
        return this.cineaction;
    }

    private void createTablePanel() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setName(CommandLineHelpDialog.class.getName() + "tablePanel");
        Font font = this.tablePanel.getFont();
        this.rowValues = new ArrayList();
        int nog = 0;
        int noCmd = 0;
        try {
            String nogrp = CvUtils.getResourceBundle().getString("Command.Groups");
            if (nogrp != null) {
                nog = Integer.parseInt(nogrp);
            }
            for (int i = 1; i <= nog; ++i) {
                String[] actionname;
                String groupname = CvUtils.getResourceBundle().getString("Command.Group." + i + ".Name");
                this.rowValues.add(null);
                this.rowValues.add(null);
                this.rowValues.add(groupname);
                this.rowValues.add(null);
                int noc = 0;
                String groupactions = CvPropertiesManager.getProperty("Command.Group." + i + ".Actions");
                if (groupactions == null || groupactions.equals("") || (actionname = groupactions.split(",")) == null || actionname.equals("")) continue;
                noc = actionname.length;
                noCmd += noc;
                for (int j = 0; j < noc; ++j) {
                    Class<?> c = Class.forName(actionname[j]);
                    Action a = (Action)c.newInstance();
                    this.allaction.add(a);
                    String cmd = (String)a.getValue("ActionCommandKey");
                    String shortcmd = (String)a.getValue("SHORT_COMMAND");
                    String cmdsyntax = (String)a.getValue("COMMAND_SYNTAX");
                    String cmddesc = (String)a.getValue("LongDescription");
                    this.rowValues.add(cmd);
                    this.rowValues.add(shortcmd);
                    this.rowValues.add(cmdsyntax);
                    this.rowValues.add(cmddesc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cm = new CommandTableModel(nog + noCmd, this.columnNames, this.rowValues);
        this.table = new JTable(this.cm);
        this.table.setFont(new Font(font.getFontName(), font.getStyle(), 11));
        this.table.getTableHeader().setFont(new Font(font.getFontName(), font.getStyle(), 12));
        this.table.setName(CommandLineHelpDialog.class.getName() + "table");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(160);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.table.getColumnModel().getColumn(1).setResizable(false);
        this.table.getColumnModel().getColumn(2).setResizable(false);
        this.table.getColumnModel().getColumn(3).setResizable(false);
        this.table.getTableHeader().setPreferredSize(new Dimension(100, 40));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new TextAreaRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new TextAreaRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new TextAreaRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new TextAreaRenderer());
        this.table.getTableHeader().setReorderingAllowed(false);
        JScrollPane jsp = new JScrollPane(this.table);
        this.tablePanel.add((Component)jsp, "Center");
        this.table.setSelectionMode(0);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, true), "Enter");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int selectedRow = CommandLineHelpDialog.this.table.getSelectedRow();
                    if ((String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 3) != null) {
                        String cmd = (String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 0);
                        CommandLineHelpDialog.this.update(cmd);
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if (e.getKeyCode() == 10 && (selectedRow = CommandLineHelpDialog.this.table.getSelectedRow()) >= 0 && (String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 3) != null) {
                    String cmd = (String)CommandLineHelpDialog.this.cm.getValueAt(selectedRow, 0);
                    CommandLineHelpDialog.this.update(cmd);
                }
            }
        });
    }

    private void clearSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandLineHelpDialog.this.table.clearSelection();
            }
        });
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(this.panelBorder);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        this.buttonPanel.setName(CommandLineHelpDialog.class.getName() + "buttonPanel");
        this.cancel = new JButton(CvUtils.getResourceBundle().getString("XP_BUT_CANCEL"));
        this.cancel.setName(CommandLineHelpDialog.class.getName() + "cancel");
        this.accept = new JButton(CvUtils.getResourceBundle().getString("XP_BUT_ACCEPT"));
        this.accept.setName(CommandLineHelpDialog.class.getName() + "accept");
        this.cancel.setFocusable(false);
        this.accept.setFocusable(false);
        this.cancel.setPreferredSize(new Dimension(150, 30));
        this.accept.setPreferredSize(new Dimension(150, 30));
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.add(this.accept);
        this.cancel.addActionListener(this.btnl);
        this.accept.addActionListener(this.btnl);
        this.cancel.setActionCommand(CANCEL);
        this.accept.setActionCommand(ACCEPT);
    }

    private void update(String command2) {
        List observer = (List)this.observers.clone();
        Iterator iter = observer.iterator();
        while (iter.hasNext()) {
            ((CommandObserver)iter.next()).notify(command2);
        }
        this.clearSelection();
        this.setVisible(false);
    }

    public void attach(CommandObserver o) {
        this.observers.add(o);
    }

    public void detach(CommandObserver o) {
        this.observers.remove(o);
    }
}

