/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.commands;

import com.ge.med.cse.cvf.action.XpLoadESIAction;
import com.ge.med.cse.cvf.action.XpTextPageSeriesAction;
import com.ge.med.cse.cvf.commands.CommandExecuter;
import com.ge.med.cse.cvf.commands.CommandHelp;
import com.ge.med.cse.cvf.commands.CommandObserver;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TclShell
extends XPcaAutoControlPanel
implements CommandObserver,
KeyEventPostProcessor,
PropertyChangeListener {
    public static final String _name = "TclShell";
    private JTextField commandLine;
    private JLabel commandPrompt;
    private String command;
    private JPanel panel = new JPanel();
    private JPanel emptyPanel = new JPanel();
    private HashMap actions = null;
    private static String MODE_PREFIX = "";
    private HashMap<String, CommandExecuter> commands_ = new HashMap();
    private static final String cmdDelimiter = "\\s+";
    public int historyLength = 20;
    private int historyCursor = 0;
    private Vector historyCommands = new Vector();
    private CommandHelp cmd = null;
    private XpLoadESIAction esi = null;
    Capable ca;
    Thread hastExec;
    Logger dlogger = Logger.getLogger(this.getClass().getName());
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public TclShell() {
        this.setLayout(new BorderLayout());
        this.panel.setLayout(new GridBagLayout());
        this.panel.setName(TclShell.class.getName() + "panel");
        Font font = new Font("SansSerif", 1, 14);
        this.commandPrompt = new JLabel(" % ");
        this.commandPrompt.setFont(font);
        this.commandPrompt.setBorder(null);
        this.commandLine = new JTextField("");
        this.commandLine.setName(_name);
        this.commandLine.setFont(font);
        this.commandLine.setBorder(null);
        this.commandLine.setOpaque(true);
        this.commandLine.setPreferredSize(new Dimension(200, 27));
        this.commandPrompt.setOpaque(true);
        this.commandLine.setBackground(Color.WHITE);
        this.commandPrompt.setBackground(Color.WHITE);
        this.commandPrompt.setName(TclShell.class.getName() + "commandPrompt");
        this.commandLine.addKeyListener(new ShellKeyListener());
        this.panel.add((Component)this.commandPrompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.commandLine, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panel, "South");
        this.panel.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    @Override
    public void setScreen(XPscreen scrn) {
        String[] propsToAdd;
        super.setScreen(scrn);
        this.screen_ = scrn;
        for (String propertyName : propsToAdd = CvPropertiesManager.getProperty("Selector.Modes", "").split(",")) {
            this.screen_.removePropertyChangeListener(propertyName, this);
            this.screen_.addPropertyChangeListener(propertyName, this);
        }
        HelperThread ht = new HelperThread();
        ht.start();
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
        this.base_ = ca;
    }

    private void createAllActions() {
        int nog = 0;
        int noa = 0;
        this.actions = new HashMap();
        XPscreen ca = this.getScreen();
        try {
            this.cmd = new CommandHelp(this);
            this.cmd.setCapable(this.getScreen());
            this.commands_.put("?", this.cmd);
            this.commands_.put("help", this.cmd);
            String nogrp = CvUtils.getResourceBundle().getString("Command.Groups");
            if (nogrp != null) {
                nog = Integer.parseInt(nogrp);
            }
            for (int i = 1; i <= nog; ++i) {
                String[] actionname;
                String groupactions = CvPropertiesManager.getProperty("Command.Group." + i + ".Actions");
                if (groupactions == null || groupactions.equals("") || (actionname = groupactions.split(",")) == null || actionname.equals("")) continue;
                noa = actionname.length;
                for (int j = 0; j < noa; ++j) {
                    Class<?> c = Class.forName(actionname[j]);
                    Action a = (Action)c.newInstance();
                    if (a instanceof CapableListener) {
                        ((CapableListener)((Object)a)).setControlArea(this.base_);
                    }
                    this.actions.put(actionname[j], a);
                    CommandExecuter ce = new CommandExecuter(a, ca);
                    String cmdname = null;
                    cmdname = (String)a.getValue("ActionCommandKey");
                    if (cmdname != null) {
                        this.commands_.put(cmdname, ce);
                    }
                    if ((cmdname = (String)a.getValue("SHORT_COMMAND")) == null) continue;
                    this.commands_.put(cmdname, ce);
                }
            }
            if (this.actions.containsKey(XpLoadESIAction.class.getName())) {
                this.esi = (XpLoadESIAction)this.actions.get(XpLoadESIAction.class.getName());
                this.esi.setCapable(ca);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enableAllActions() {
        if (this.actions == null) {
            this.createAllActions();
        } else {
            for (Map.Entry entry : this.actions.entrySet()) {
                Action a = (Action)entry.getValue();
                FrameCapable fcap = (FrameCapable)((Object)this.screen_.getCapable(FrameCapable.class.getName()));
                if (a != null) {
                    if (a instanceof XpTextPageSeriesAction) {
                        if (fcap.getNumFrames() > CvUtils.getLargeSeriesSize()) {
                            a.setEnabled(false);
                        }
                    } else {
                        a.setEnabled(true);
                    }
                }
                MODE_PREFIX = "";
            }
        }
    }

    private void enableRefVpSelectedActions() {
        try {
            String[] actionname;
            for (Map.Entry entry : this.actions.entrySet()) {
                Action a = (Action)entry.getValue();
                a.setEnabled(false);
            }
            String actionString = CvPropertiesManager.getProperty("cvf.refVpSelected.actions");
            if (actionString != null && (actionname = actionString.split(",")) != null && actionname.length > 0) {
                for (int i = 0; i < actionname.length; ++i) {
                    Action a = (Action)this.actions.get(actionname[i].trim());
                    if (a != null) {
                        a.setEnabled(true);
                    }
                    MODE_PREFIX = CvUtils.getResourceBundle().getString("REFVP_SELECT");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableRefVpUnSelectedActions() {
        try {
            String[] actionname;
            for (Map.Entry entry : this.actions.entrySet()) {
                Action a = (Action)entry.getValue();
                a.setEnabled(false);
            }
            String actionString = CvPropertiesManager.getProperty("cvf.refVpUnSelected.actions");
            if (actionString != null && (actionname = actionString.split(",")) != null && actionname.length > 0) {
                for (int i = 0; i < actionname.length; ++i) {
                    Action a = (Action)this.actions.get(actionname[i]);
                    if (a != null) {
                        a.setEnabled(true);
                    }
                    MODE_PREFIX = CvUtils.getResourceBundle().getString("REFVP_ON");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enableCineActions() {
        try {
            String[] actionname;
            for (Map.Entry entry : this.actions.entrySet()) {
                Action a = (Action)entry.getValue();
                a.setEnabled(false);
            }
            String actionString = CvPropertiesManager.getProperty("cvf.cine.actions");
            if (actionString != null && (actionname = actionString.split(",")) != null && actionname.length > 0) {
                for (int i = 0; i < actionname.length; ++i) {
                    Action a = (Action)this.actions.get(actionname[i]);
                    if (a != null) {
                        a.setEnabled(true);
                    }
                    MODE_PREFIX = CvUtils.getResourceBundle().getString("CINE_ON");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void evalCommand() {
        this.command = this.commandLine.getText().trim();
        this.commandLine.setText("");
        if (this.command.length() > 0) {
            this.dlogger.log(UserMessageLevel.USER_MSG, "");
            int optionidx = this.command.indexOf(" ");
            String cmd = this.command;
            String option = "";
            if (optionidx != -1) {
                cmd = this.command.substring(0, optionidx);
                option = this.command.substring(optionidx, this.command.length());
            }
            this.command = cmd.toLowerCase() + option;
            if (this.esi != null && this.esi.isEnabled() && this.esi.validateCommand(this.command)) {
                System.err.println("================= ESI enabled : " + this.esi.isEnabled());
                ActionEvent e = new ActionEvent(this.getScreen(), 100000, this.command);
                this.esi.actionPerformed(e);
            } else {
                String[] vals = this.command.split(cmdDelimiter);
                if (vals != null && vals.length > 0) {
                    CommandExecuter ce = this.commands_.get(vals[0]);
                    if (ce != null) {
                        ce.setUserMsgModePrefix(MODE_PREFIX);
                        ce.cmdProc(vals);
                    } else {
                        this.dlogger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_CMD") + " " + '\"' + vals[0] + '\"');
                        this.dlogger.log(Level.WARNING, "Invalid Command : " + this.command);
                    }
                }
            }
            this.updateHistory(this.command);
        }
    }

    private void updateHistory(String command2) {
        this.historyCursor = 0;
        if (this.historyCommands.size() == this.historyLength) {
            this.historyCommands.removeElementAt(0);
        }
        this.historyCommands.addElement(this.command);
    }

    public void nextCommand() {
        String text;
        if (this.historyCursor == 0) {
            text = "";
        } else {
            --this.historyCursor;
            text = (String)this.historyCommands.elementAt(this.historyCommands.size() - this.historyCursor - 1);
        }
        this.commandLine.setText(text);
    }

    public void previousCommand() {
        if (this.historyCursor == this.historyCommands.size()) {
            return;
        }
        ++this.historyCursor;
        String text = (String)this.historyCommands.elementAt(this.historyCommands.size() - this.historyCursor);
        this.commandLine.setText(text);
    }

    @Override
    public void notify(String command2) {
        this.commandLine.setText(command2 + " ");
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent e) {
        if (!e.isConsumed() && !(e.getComponent() instanceof JTextComponent) && e.getID() == 401) {
            if (e.getKeyCode() == 10) {
                this.evalCommand();
            } else if (e.getKeyCode() == 8) {
                String txt = this.commandLine.getText();
                if (txt.length() > 0) {
                    this.commandLine.setText(txt.substring(0, txt.length() - 1));
                }
            } else if (this.commandLine.getText().length() <= 100 && (Character.isWhitespace(e.getKeyChar()) || e.getKeyChar() >= '!' && e.getKeyChar() <= '~')) {
                this.commandLine.setText(this.commandLine.getText() + e.getKeyChar());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
        }
        this.panel.setEnabled(enabled);
        this.commandLine.setEditable(enabled);
    }

    public void dispose() {
        this.setEnabled(false);
        this.commands_.clear();
        this.commands_ = null;
        this.historyCommands.clear();
        this.historyCommands = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean value = false;
        if (evt.getPropertyName().equalsIgnoreCase("reference_vp_selection")) {
            value = Boolean.parseBoolean(evt.getNewValue().toString());
            if (value) {
                this.enableRefVpSelectedActions();
            } else {
                this.enableRefVpUnSelectedActions();
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("reference_viewport")) {
            value = Boolean.parseBoolean(evt.getNewValue().toString());
            if (value) {
                this.enableRefVpUnSelectedActions();
            } else {
                this.enableAllActions();
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("Cine")) {
            value = Boolean.parseBoolean(evt.getNewValue().toString());
            if (value) {
                this.enableCineActions();
            } else {
                this.enableAllActions();
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("minmax_property")) {
            value = Boolean.parseBoolean(evt.getNewValue().toString());
            if (value) {
                this.enableMinMaxAction();
            } else {
                this.enableAllActions();
            }
        }
    }

    private void enableMinMaxAction() {
        try {
            String[] actionname;
            for (Map.Entry entry : this.actions.entrySet()) {
                Action a = (Action)entry.getValue();
                a.setEnabled(false);
            }
            String actionString = CvPropertiesManager.getProperty("cvf.minMax.actions");
            if (actionString != null && (actionname = actionString.split(",")) != null && actionname.length > 0) {
                for (int i = 0; i < actionname.length; ++i) {
                    Action a = (Action)this.actions.get(actionname[i]);
                    if (a == null) continue;
                    a.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class HelperThread
    extends Thread {
        HelperThread() {
        }

        @Override
        public void run() {
            TclShell.this.createAllActions();
            TclShell.this.setEnabled(true);
        }
    }

    class ShellKeyListener
    implements KeyListener {
        ShellKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    keyEvent.consume();
                    TclShell.this.evalCommand();
                    break;
                }
                case 38: {
                    TclShell.this.previousCommand();
                    break;
                }
                case 40: {
                    TclShell.this.nextCommand();
                    break;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\b' && TclShell.this.commandLine.getText().length() == 100) {
                e.consume();
                return;
            }
        }
    }
}

