/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpScreenFullAnnotAction;
import com.ge.med.cse.cvf.action.XpScreenNoAnnotAction;
import com.ge.med.cse.cvf.action.XpScreenPartAnnotAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.cpanels.XpCustomAnnotPanel;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class XpAnnotationSettingPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack {
    JRadioButton fullAnnot;
    JRadioButton partlAnnot;
    JRadioButton noAnnot;
    JRadioButton custmAnnot;
    JPanel radbutPanel;
    JPanel saveBtPanel;
    JPanel mainPanel;
    JPanel topPanel;
    JButton custm;
    JButton save;
    ButtonGroup bg;
    private boolean initialized = false;
    public String modality;
    XpCustomAnnotPanel custmPanel = new XpCustomAnnotPanel(this);
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equals("data_changed")) {
                XpAnnotationSettingPanel.this.loadAnnotationPreferences();
                if (!XpAnnotationSettingPanel.this.initialized) {
                    XpAnnotationSettingPanel.this.updateAnnotationSettings();
                    XpAnnotationSettingPanel.this.initialized = true;
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("screen_annotation_level")) {
                String level = (String)evt.getNewValue();
                if (level == null) {
                    return;
                }
                if (level.equalsIgnoreCase("all")) {
                    XpAnnotationSettingPanel.this.fullAnnot.setSelected(true);
                } else if (level.equalsIgnoreCase("partial")) {
                    XpAnnotationSettingPanel.this.partlAnnot.setSelected(true);
                } else if (level.equalsIgnoreCase("custom")) {
                    XpAnnotationSettingPanel.this.custmAnnot.setSelected(true);
                } else {
                    XpAnnotationSettingPanel.this.noAnnot.setSelected(true);
                }
            }
        }
    };

    public XpAnnotationSettingPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateAnnotationPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating Annotation Panel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating Annotation Panel", tln);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        this.setTitle(CvUtils.getResourceBundle().getString("XP_ANNOTATION_SETTINGS_TITLE"));
        this.fullAnnot = new JRadioButton();
        this.fullAnnot.setAction(new XpScreenFullAnnotAction());
        this.fullAnnot.setFocusable(false);
        this.fullAnnot.setName("fullAnnotn");
        this.partlAnnot = new JRadioButton();
        this.partlAnnot.setAction(new XpScreenPartAnnotAction());
        this.partlAnnot.setFocusable(false);
        this.partlAnnot.setName("partlAnnotn");
        this.noAnnot = new JRadioButton();
        this.noAnnot.setAction(new XpScreenNoAnnotAction());
        this.noAnnot.setFocusable(false);
        this.noAnnot.setName("noAnnotn");
        this.custmAnnot = new JRadioButton();
        this.custmAnnot.setText(CvUtils.getResourceBundle().getString("XP_CUSTM_ANN_NAME"));
        this.custmAnnot.setFocusable(false);
        this.custmAnnot.setName("custmAnnotn");
        this.custmAnnot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpAnnotationSettingPanel.this.custm_actionPerformed(e);
            }
        });
        this.bg = new ButtonGroup();
        this.bg.add(this.fullAnnot);
        this.bg.add(this.partlAnnot);
        this.bg.add(this.noAnnot);
        this.bg.add(this.custmAnnot);
        this.updateAnnotationSettings();
        this.custm = new JButton();
        this.custm.setText(CvUtils.getResourceBundle().getString("XP_ANNOT_CUSTOM_NAME"));
        this.custm.setFocusable(false);
        this.custm.setName("custmBtn");
        this.custm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpAnnotationSettingPanel.this.custm_but_actionPerformed(e);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.custmAnnot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 20), 0, 0));
        panel.add((Component)this.custm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.saveBtPanel = new JPanel();
        this.save = new JButton(new XpSavePrefsAction(this));
        this.save.setText(CvUtils.getResourceBundle().getString("XP_SAVE_PREFS_NAME"));
        this.save.setFocusable(false);
        this.save.setName("annotSaveBtn");
        this.saveBtPanel.setLayout(new GridBagLayout());
        this.saveBtPanel.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.saveBtPanel.setName(XpAnnotationSettingPanel.class.getName() + "saveBtPanel");
        this.radbutPanel = new JPanel();
        this.radbutPanel.setLayout(new GridBagLayout());
        this.radbutPanel.add((Component)this.fullAnnot, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 10, 0), 0, 0));
        this.radbutPanel.add((Component)this.partlAnnot, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.radbutPanel.add((Component)this.noAnnot, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.radbutPanel.add((Component)panel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 10, 20), 0, 0));
        this.radbutPanel.setName(XpAnnotationSettingPanel.class.getName() + "radbutPanel");
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)this.radbutPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 40, 0), 0, 0));
        panel1.add((Component)this.saveBtPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel1.setName(XpAnnotationSettingPanel.class.getName() + "panel1");
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)panel1, "North");
        this.mainPanel.setName(XpAnnotationSettingPanel.class.getName() + "mainPanel");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.mainPanel, "Center");
        this.topPanel.setName(XpAnnotationSettingPanel.class.getName() + "topPanel");
        this.add((Component)this.topPanel, "Center");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.screen_ = screen;
        this.getScreen().removePropertyChangeListener(this.vpListener);
        this.getScreen().addPropertyChangeListener(this.vpListener);
        Action action = this.fullAnnot.getAction();
        if (action instanceof PlasmaControl) {
            ((PlasmaControl)((Object)action)).setCapable(screen);
        }
        if ((action = this.partlAnnot.getAction()) instanceof PlasmaControl) {
            ((PlasmaControl)((Object)action)).setCapable(screen);
        }
        if ((action = this.noAnnot.getAction()) instanceof PlasmaControl) {
            ((PlasmaControl)((Object)action)).setCapable(screen);
        }
        this.loadAnnotationPreferences();
    }

    private void loadAnnotationPreferences() {
        String annotLevel;
        SelectionCapable sc = (SelectionCapable)this.getScreen().getCapable(SelectionCapable.class.getName());
        FrameCapable frameCapable = (FrameCapable)((Object)this.getScreen().getCapable(FrameCapable.class.getName()));
        if (frameCapable == null || sc == null) {
            return;
        }
        if (frameCapable.getFrame() == null) {
            return;
        }
        ((AnnotCapable)((Object)sc)).setAnnotationVisible(true);
        String mod = this.getModality();
        int largefontmask = XPDisplayPrefsUtils.getScreenLargeFontAnnotationLevel();
        if (largefontmask != 0) {
            Capable ca = (Capable)((Object)sc.getViewportComponent(sc.getComponentSelection()));
            XpFrameVisualizer fv = null;
            if (ca instanceof XpCompositePort) {
                fv = ((XpCompositePort)ca).getPort(0);
            } else if (ca instanceof XpSingularPort) {
                fv = (XpFrameVisualizer)((XpSingularPort)ca);
            }
            int[] annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(fv, mod, largefontmask);
            XPDisplayPrefsUtils.setLargeFontAnnotation((AnnotCapable)ca, annotkey);
        }
        if (!(annotLevel = XPDisplayPrefsUtils.getScreenAnnotationLevel()).equals("custom")) {
            XPDisplayPrefsUtils.setAnnotLevel((AnnotCapable)((Object)sc), annotLevel);
        } else {
            int mask = XPDisplayPrefsUtils.getScreenCustomAnnotationLevel();
            XPDisplayPrefsUtils.setCustomAnnotItems((AnnotCapable)((Object)sc), mod, mask);
        }
        this.getScreen().updateUI();
    }

    private void custm_actionPerformed(ActionEvent e) {
        TransactionLogName tln = new TransactionLogName("TID=CV_Annotationlevel_Custom");
        AnnotCapable annotCapble = (AnnotCapable)this.getScreen().getCapable(AnnotCapable.class.getName());
        if (annotCapble != null) {
            this.modality = this.getModality();
            XPDisplayPrefsUtils.updateScreenAnnotationLevel("custom");
            this.logger.log(Level.FINEST, "{0} begin", tln);
            XPDisplayPrefsUtils.setCustomAnnotItems(annotCapble, this.modality, XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
            this.logger.log(Level.FINEST, "{0} end", tln);
        } else {
            this.logger.log(Level.INFO, "{0}SEV5 Not AnnotCapable", tln);
        }
    }

    private void custm_but_actionPerformed(ActionEvent e) {
        this.topPanel.removeAll();
        this.topPanel.add((Component)this.custmPanel, "Center");
        this.custmPanel.setScreen(this.screen_);
        this.topPanel.updateUI();
    }

    public String getModality() {
        XpMedicalImage img;
        FrameOwner fo = (FrameOwner)((Object)this.screen_.getCapable(FrameOwner.class.getName()));
        if (fo != null && (img = (XpMedicalImage)fo.getFrame()) != null) {
            this.modality = DicomUtils.getModality(img);
        }
        return this.modality;
    }

    @Override
    public void sync() {
        if (this.fullAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveScreenAnnotationLevel("all");
        } else if (this.partlAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveScreenAnnotationLevel("partial");
        } else if (this.noAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveScreenAnnotationLevel("none");
        } else if (this.custmAnnot.isSelected()) {
            XPDisplayPrefsUtils.saveScreenAnnotationLevel("custom");
            XPDisplayPrefsUtils.saveScreenCustomAnnotationLevel(XPDisplayPrefsUtils.getScreenCustomAnnotationLevel());
        }
    }

    private void updateAnnotationSettings() {
        String annotLevel = XPDisplayPrefsUtils.getScreenAnnotationLevel();
        if (annotLevel.equals("all")) {
            this.fullAnnot.setSelected(true);
        } else if (annotLevel.equals("partial")) {
            this.partlAnnot.setSelected(true);
        } else if (annotLevel.equals("none")) {
            this.noAnnot.setSelected(true);
        } else if (annotLevel.equals("custom")) {
            this.custmAnnot.setSelected(true);
        }
    }
}

