/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.prefs.XpIPrefsCallBack;
import com.ge.med.cse.cvf.prefs.XpSavePrefsAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class XpFilmLargeFontAnnotationPanel
extends XPcaAutoControlPanel
implements XpIPrefsCallBack {
    private JLabel titlelbl;
    private JButton applybtn;
    private JButton savebtn;
    private JCheckBox[] grpnames;
    private JPanel buttonPanel;
    private JPanel listPanel;
    private JPanel labelPanel;
    private String[] groupElemts;
    private String modality_;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("data_changed") || evt.getPropertyName().equals("CONTENT_CHANGED")) {
                XpFilmLargeFontAnnotationPanel.access$102(XpFilmLargeFontAnnotationPanel.this, null);
                XpFilmLargeFontAnnotationPanel.this.updateAnnotList();
            }
        }
    };

    public XpFilmLargeFontAnnotationPanel() {
        TransactionLogName tln = new TransactionLogName("TID=CreateCustomAnnotPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating Large Font Annotation Panel", tln);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end,Creating Large Font Annotation Panel", tln);
    }

    private void initUI() {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.setTitle(CvUtils.getResourceBundle().getString("XP_LARGE_FONT_TITLE"));
        this.titlelbl = new JLabel();
        this.titlelbl.setText(CvUtils.getResourceBundle().getString("XP_ANNOT_LARGE_FONT_PA_LB"));
        this.titlelbl.setName(XpFilmLargeFontAnnotationPanel.class.getName() + "titlelbl");
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(null);
        this.labelPanel.add((Component)this.titlelbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 0, 0), 0, 0));
        this.labelPanel.setName(XpFilmLargeFontAnnotationPanel.class.getName() + "labelPanel");
        JPanel topLabel = new JPanel();
        topLabel.setLayout(new BorderLayout());
        topLabel.setBackground(null);
        topLabel.add((Component)this.labelPanel, "West");
        topLabel.setName(XpFilmLargeFontAnnotationPanel.class.getName() + "topLabel");
        this.listPanel = new JPanel();
        this.listPanel.setName("largeFontFilmAnnotsPnl");
        this.listPanel.setLayout(new GridLayout(0, 1));
        this.listPanel.setBackground(UIManager.getColor("P9"));
        this.savebtn = new JButton(new XpSavePrefsAction(this));
        this.savebtn.setText(CvUtils.getResourceBundle().getString("XP_SAVE_PREFS_NAME"));
        this.savebtn.setFocusable(false);
        this.savebtn.setName("largeFontFilmSaveBtn");
        this.applybtn = new JButton();
        this.applybtn.setText(CvUtils.getResourceBundle().getString("XP_BUT_APPLY"));
        this.applybtn.setFocusable(false);
        this.applybtn.setName("largeFontApplyBtn");
        this.applybtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpFilmLargeFontAnnotationPanel.this.ok_button_actionPerformed(e);
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(null);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.savebtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 100, 20), 0, 0));
        this.buttonPanel.add((Component)this.applybtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.setName(XpFilmLargeFontAnnotationPanel.class.getName() + "buttonPanel");
        this.add((Component)topLabel, "North");
        this.add((Component)this.listPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.updateAnnotList();
        screen.removePropertyChangeListener(this.vpListener);
        screen.addPropertyChangeListener(this.vpListener);
    }

    public void updateAnnotList() {
        if (this.grpnames != null) {
            return;
        }
        this.modality_ = this.getModality();
        this.groupElemts = XPDisplayPrefsUtils.getLargeFontAnnotationGroups(this.modality_);
        if (this.groupElemts != null) {
            this.grpnames = new JCheckBox[this.groupElemts.length];
            this.listPanel.removeAll();
            for (int i = 0; i < this.groupElemts.length; ++i) {
                String text = this.groupElemts[i];
                try {
                    text = CvUtils.getResourceBundle().getString(this.modality_.toLowerCase() + "." + this.groupElemts[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.grpnames[i] = new JCheckBox(i + 1 + "." + text.replace('_', ' '));
                this.grpnames[i].setName(XpFilmLargeFontAnnotationPanel.class.getName() + "grpnames-" + i);
                this.grpnames[i].setActionCommand(this.groupElemts[i]);
                boolean isSelected = XPDisplayPrefsUtils.queryFilmLargeFontAnnotationGroup(i);
                this.grpnames[i].setFocusable(false);
                this.grpnames[i].setSelected(isSelected);
                this.listPanel.add(this.grpnames[i]);
            }
        }
    }

    private void ok_button_actionPerformed(ActionEvent e) {
        int custmmask = 0;
        for (int i = 0; i < this.grpnames.length; ++i) {
            if (!this.grpnames[i].isSelected()) continue;
            int grMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(i);
            custmmask |= grMask;
        }
        XPDisplayPrefsUtils.updateFilmLargeFontAnnotationLevel(custmmask);
    }

    public String getModality() {
        XpMedicalImage img;
        FrameOwner fo = (FrameOwner)((Object)this.getScreen().getCapable(FrameOwner.class.getName()));
        if (fo != null && (img = (XpMedicalImage)fo.getFrame()) != null) {
            return DicomUtils.getModality(img);
        }
        return null;
    }

    @Override
    public void sync() {
        int custmmask = 0;
        for (int i = 0; i < this.grpnames.length; ++i) {
            if (!this.grpnames[i].isSelected()) continue;
            int grMask = XPDisplayPrefsUtils.getLargeFontAnnotationGroupMask(i);
            custmmask |= grMask;
        }
        XPDisplayPrefsUtils.saveFilmLargeFontAnnotationLevel(custmmask);
    }

    static /* synthetic */ JCheckBox[] access$102(XpFilmLargeFontAnnotationPanel x0, JCheckBox[] x1) {
        x0.grpnames = x1;
        return x1;
    }
}

